
    create table CHANGEPLAN (
        ID integer not null auto_increment,
        END_OF_EXECUTION datetime,
        RESOLUTION_ERROR varchar(255),
        START_OF_EXECUTION datetime,
        STATE varchar(255),
        USERNAME varchar(255),
        primary key (ID)
    ) ENGINE=InnoDB;

    create table CHANGES (
        ID integer not null auto_increment,
        CHANGEPLAN_ID integer,
        HANDLE_ID integer,
        NEW_REVISION_ID integer,
        OLD_REVISION_ID integer,
        primary key (ID)
    ) ENGINE=InnoDB;

    create table CI_HANDLE (
        ID integer not null auto_increment,
        DESCRIPTION text,
        LABEL varchar(255),
        TYPE varchar(255),
        ACTUAL_REVISION_ID integer,
        primary key (ID)
    ) ENGINE=InnoDB;

    create table CI_REVISION (
        ID integer not null auto_increment,
        DETAILS text,
        HANDLE_ID integer,
        PERMISSION_SCHEME_ID integer,
        primary key (ID)
    ) ENGINE=InnoDB;

    create table NAMED_CI_RELATION (
        ID integer not null auto_increment,
        PROPERTY_NAME varchar(255),
        OWNING_REVISION_ID integer,
        TARGET_HANDLE_ID integer,
        primary key (ID)
    ) ENGINE=InnoDB;

    create table STEP (
        STEP_ID integer not null auto_increment,
        DEFININGFILE varchar(255),
        DESCRIPTION varchar(255),
        LANGUAGE varchar(255),
        LOG text,
        POS integer,
        DETAILS blob,
        STATE varchar(255),
        CHANGEPLAN_ID integer,
        primary key (STEP_ID)
    ) ENGINE=InnoDB;

    create index CHANGEPLAN_USERNAME_IX on CHANGEPLAN (USERNAME);

    create index CHANGEPLAN_STATE_IX on CHANGEPLAN (STATE);

    create index CHANGES_CHANGEPLAN on CHANGES (CHANGEPLAN_ID);

    create index CHANGES_HANDLE on CHANGES (HANDLE_ID);

    alter table CHANGES 
        add index FK_CHANGES_OLD_REVISION (OLD_REVISION_ID), 
        add constraint FK_CHANGES_OLD_REVISION 
        foreign key (OLD_REVISION_ID) 
        references CI_REVISION (ID);

    alter table CHANGES 
        add index FK_CHANGES_NEW_REVISION (NEW_REVISION_ID), 
        add constraint FK_CHANGES_NEW_REVISION 
        foreign key (NEW_REVISION_ID) 
        references CI_REVISION (ID);

    alter table CHANGES 
        add index FK_CHANGES_CHANGEPLAN (CHANGEPLAN_ID), 
        add constraint FK_CHANGES_CHANGEPLAN 
        foreign key (CHANGEPLAN_ID) 
        references CHANGEPLAN (ID);

    alter table CHANGES 
        add index FK_CHANGES_HANDLE (HANDLE_ID), 
        add constraint FK_CHANGES_HANDLE 
        foreign key (HANDLE_ID) 
        references CI_HANDLE (ID);

    create index CI_HANDLE_ACTUAL_REVISION_IX on CI_HANDLE (ACTUAL_REVISION_ID);

    create index CI_HANDLE_LABEL_UN on CI_HANDLE (LABEL);

    alter table CI_HANDLE 
        add index CI_HANDLE_ACTUAL_REVISION_FK (ACTUAL_REVISION_ID), 
        add constraint CI_HANDLE_ACTUAL_REVISION_FK 
        foreign key (ACTUAL_REVISION_ID) 
        references CI_REVISION (ID);

    alter table CI_REVISION 
        add index CI_REVISION_PERMISSION_FK (PERMISSION_SCHEME_ID), 
        add constraint CI_REVISION_PERMISSION_FK 
        foreign key (PERMISSION_SCHEME_ID) 
        references CI_HANDLE (ID);

    alter table CI_REVISION 
        add index FK_CI_REVISION_HANDLE (HANDLE_ID), 
        add constraint FK_CI_REVISION_HANDLE 
        foreign key (HANDLE_ID) 
        references CI_HANDLE (ID);

    alter table NAMED_CI_RELATION 
        add index FKAB16858FF031847D (TARGET_HANDLE_ID), 
        add constraint FKAB16858FF031847D 
        foreign key (TARGET_HANDLE_ID) 
        references CI_HANDLE (ID);

    alter table NAMED_CI_RELATION 
        add index FKAB16858F792C2768 (OWNING_REVISION_ID), 
        add constraint FKAB16858F792C2768 
        foreign key (OWNING_REVISION_ID) 
        references CI_REVISION (ID);

    alter table STEP 
        add index FK_STEP_CHANGEPLAN (CHANGEPLAN_ID), 
        add constraint FK_STEP_CHANGEPLAN 
        foreign key (CHANGEPLAN_ID) 
        references CHANGEPLAN (ID);
