/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.service.impl;

import com.xebia.ad.DeployItConfiguration;
import com.xebia.ad.application.importer.DeploymentPackageImportService;
import com.xebia.ad.application.importer.DeploymentPackageLocation;
import com.xebia.ad.dao.ConfigurationItemHandleDao;
import com.xebia.ad.repository.ConfigurationItemTypeDescriptorRepository;
import com.xebia.ad.repository.metadata.Change;
import com.xebia.ad.repository.metadata.ChangePlan;
import com.xebia.ad.repository.metadata.ConfigurationItemHandle;
import com.xebia.ad.repository.metadata.ConfigurationItemRevision;
import com.xebia.ad.service.AutomatedDeploymentService;
import com.xebia.ad.service.ChangePlanService;
import com.xebia.ad.service.ConfigurationItemMetaData;
import com.xebia.ad.service.ReportingService;
import com.xebia.ad.service.RepositoryService;
import com.xebia.ad.service.ServerManagementService;
import com.xebia.ad.service.UserService;
import com.xebia.ad.service.design.ui.ChangePlanView;
import com.xebia.ad.service.dto.DTOFactory;
import com.xebia.ad.support.Triple;
import com.xebialabs.deployit.StepExecutionContextListener;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.security.AccessControlEntry;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.mapper.Pair;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Transactional
public class AutomatedDeploymentServiceImpl
implements AutomatedDeploymentService {
    @Autowired
    @Qualifier(value="defaultRepositoryService")
    public RepositoryService repositoryService;
    @Autowired
    public ChangePlanService changePlanService;
    @Autowired
    public DeploymentPackageImportService deploymentPackageImportService;
    @Autowired
    public UserService userService;
    @Autowired
    public ServerManagementService serverManagementService;
    @Autowired
    private ReportingService reportingService;
    @Autowired
    public ConfigurationItemHandleDao configurationItemHandleDao;
    @Autowired
    public DTOFactory dtoFactory;
    @Autowired
    private ConfigurationItemTypeDescriptorRepository descriptorRepository;
    private DeployItConfiguration configuration = DeployItConfiguration.loadForUse();
    private Logger logger = Logger.getLogger(AutomatedDeploymentServiceImpl.class);

    @Override
    public String getCurrentUsername() {
        return this.userService.getCurrentUsername();
    }

    @Override
    public AccessControlEntry getGlobalPermissionsForCurrentUser() {
        return this.repositoryService.getGlobalPermissionsForCurrentUser();
    }

    @Override
    public Collection<ConfigurationItemDescriptor> getConfigurationItemDescriptors() {
        return this.descriptorRepository.getDescriptors();
    }

    @Override
    public Collection<ConfigurationItemMetaData> getActuals() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Getting all actuals");
        }
        Collection<Pair<ConfigurationItemRevision, AccessControlEntry>> actualRevisions = this.repositoryService.getActualRevisions();
        ArrayList<ConfigurationItemMetaData> actuals = new ArrayList<ConfigurationItemMetaData>();
        for (Pair<ConfigurationItemRevision, AccessControlEntry> p : actualRevisions) {
            ConfigurationItemRevision revision = (ConfigurationItemRevision)p.getFirst();
            AccessControlEntry permissions = (AccessControlEntry)p.getSecond();
            String type = revision.getHandle().getType();
            if (this.descriptorRepository.getDescriptor(type) != null) {
                actuals.add(this.dtoFactory.createActualConfigurationItemMetaData(revision, null, permissions));
                continue;
            }
            this.logger.warn((Object)("Could not find a descriptor for CI of type " + type + ". This CI type was not loaded. Check PluginLoader messages at start of server log."));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Got " + actuals.size() + " actuals"));
        }
        return actuals;
    }

    @Override
    public ConfigurationItemMetaData findDesignConfigurationItemByLabel(String label) {
        Triple<ConfigurationItemRevision, Change, AccessControlEntry> r;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Finding design configuration item with label \"" + label + "\""));
        }
        if ((r = this.repositoryService.findDesignRevisionByLabel(label)) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Could not find design configuration item with label \"" + label + "\""));
            }
            return null;
        }
        ConfigurationItemRevision revision = r.getFirst();
        Change c = r.getSecond();
        AccessControlEntry permissions = r.getThird();
        ConfigurationItemMetaData item = c == null ? this.dtoFactory.createActualConfigurationItemMetaData(revision, c, permissions) : this.dtoFactory.createDesignConfigurationItemMetaData(revision, c, permissions);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found design configuration item with label \"" + label + "\". It has handle ID " + item.getHandleId() + " and revision ID " + item.getRevisionId()));
        }
        return item;
    }

    @Override
    public ConfigurationItemMetaData findActualConfigurationItemByLabel(String label) {
        Pair<ConfigurationItemRevision, AccessControlEntry> actual;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Finding actual configuration item with label \"" + label + "\""));
        }
        if ((actual = this.repositoryService.findActualRevisionByLabel(label)) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Did not find actual configuration item with label \"" + label + "\""));
            }
            return null;
        }
        ConfigurationItemMetaData ciMetaData = this.dtoFactory.createActualConfigurationItemMetaData((ConfigurationItemRevision)actual.getFirst(), null, (AccessControlEntry)actual.getSecond());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found actual configuration item with label \"" + label + "\". It has ID \"" + ciMetaData.getHandleId() + "\""));
        }
        return ciMetaData;
    }

    @Override
    public ConfigurationItemMetaData findActualConfigurationItemByHandleId(int handleId) {
        Pair<ConfigurationItemRevision, AccessControlEntry> actual;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Finding actual configuration item with ID " + handleId));
        }
        if ((actual = this.repositoryService.findActualRevisionByHandleId(handleId)) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Did not find actual configuration item with ID " + handleId));
            }
            return null;
        }
        ConfigurationItemMetaData ciMetaData = this.dtoFactory.createActualConfigurationItemMetaData((ConfigurationItemRevision)actual.getFirst(), null, (AccessControlEntry)actual.getSecond());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found actual configuration item with ID " + handleId + ". It has label \"" + ciMetaData.getLabel() + "\""));
        }
        return ciMetaData;
    }

    @Override
    public Serializable getConfigurationItemDetailsObject(int revisionId) {
        Object details;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Getting configuration item details for revision ID " + revisionId));
        }
        if ((details = this.repositoryService.getConfigurationItemDetailsObject(revisionId)) instanceof Serializable) {
            if (this.logger.isDebugEnabled()) {
                if (details != null) {
                    this.logger.debug((Object)("Got configuration item details for revision ID " + revisionId + ". It is of type " + details.getClass().getName()));
                } else {
                    this.logger.debug((Object)("Did not get configuration item details for revision ID " + revisionId));
                }
            }
            return (Serializable)details;
        }
        throw new RuntimeException(details.getClass().getName() + " does not implement Serializable. Cannot return it to a Remote Client.");
    }

    @Override
    public Map<String, Object> getConfigurationItem(int revisionId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Getting configuration item for revision ID " + revisionId));
        }
        Object item = this.repositoryService.getConfigurationItemDetailsObject(revisionId);
        if (this.logger.isDebugEnabled()) {
            if (item != null) {
                this.logger.debug((Object)("Got configuration item for revision ID " + revisionId + ". It is of type " + item.getClass().getName()));
            } else {
                this.logger.debug((Object)("Did not get configuration item for revision ID " + revisionId));
            }
        }
        return this.dtoFactory.createConfigurationItemMap((Serializable)item);
    }

    @Override
    public void addConfigurationItem(ConfigurationItemMetaData ciMetaData, Object ciDetails) {
        String type = ciMetaData.getConfigurationItemClassName();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding configuration item \"" + ciMetaData.getLabel() + "\" of type " + type));
        }
        String label = ciMetaData.getLabel();
        String description = ciMetaData.getDescription();
        ConfigurationItemRevision revision = this.dtoFactory.createConfigurationItemRevision(ciMetaData, ciDetails);
        ConfigurationItemHandle handle = this.repositoryService.addConfigurationItem(label, description, type, revision);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Added configuration item \"" + ciMetaData.getLabel() + "\" of type " + type + ". It got handle ID " + handle.getId()));
        }
    }

    @Override
    public void updateConfigurationItem(ConfigurationItemMetaData ciMetaData, Object ciDetails) {
        ConfigurationItemRevision revision;
        if (ciDetails == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Copying existing CI details for handle ID = " + ciMetaData.getHandleId() + ", revision ID = " + ciMetaData.getRevisionId()));
            }
            revision = this.dtoFactory.createConfigurationItemRevision(ciMetaData, this.repositoryService.getConfigurationItemDetailsObject(ciMetaData.getRevisionId()));
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Updating configuration item \"" + ciMetaData.getLabel() + "\" of type " + ciMetaData.getConfigurationItemClassName() + ". It has handle ID " + ciMetaData.getHandleId()));
            }
            revision = this.dtoFactory.createConfigurationItemRevision(ciMetaData, ciDetails);
        }
        ConfigurationItemHandle handle = (ConfigurationItemHandle)this.configurationItemHandleDao.getById(Integer.valueOf(ciMetaData.getHandleId()));
        String label = ciMetaData.getLabel();
        String description = ciMetaData.getDescription();
        this.repositoryService.updateConfigurationItem(handle, label, description, revision);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Updated configuration item \"" + ciMetaData.getLabel() + "\" of type " + ciMetaData.getConfigurationItemClassName() + ". It has handle ID " + ciMetaData.getHandleId() + "."));
        }
    }

    @Override
    public void deleteConfigurationItem(ConfigurationItemMetaData ciMetaData) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleting configuration item \"" + ciMetaData.getLabel() + "\". It has handle ID " + ciMetaData.getHandleId()));
        }
        ConfigurationItemHandle handle = (ConfigurationItemHandle)this.configurationItemHandleDao.getById(Integer.valueOf(ciMetaData.getHandleId()));
        this.repositoryService.deleteConfigurationItem(handle);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleted configuration item \"" + ciMetaData.getLabel() + "\". It has handle ID " + ciMetaData.getHandleId()));
        }
    }

    @Override
    public void undoConfigurationItem(ConfigurationItemMetaData ciMetaData) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Undoing configuration item \"" + ciMetaData.getLabel() + "\". It has handle ID " + ciMetaData.getHandleId()));
        }
        ConfigurationItemHandle handle = (ConfigurationItemHandle)this.configurationItemHandleDao.getById(Integer.valueOf(ciMetaData.getHandleId()));
        this.repositoryService.undoConfigurationItem(handle, false);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Undid configuration item \"" + ciMetaData.getLabel() + "\". It has handle ID " + ciMetaData.getHandleId()));
        }
    }

    @Override
    public void revertConfigurationItem(ConfigurationItemMetaData ciMetaData) {
        Pair<ConfigurationItemRevision, AccessControlEntry> previousRevisionPair = this.repositoryService.findPreviousRevisionByHandleId(ciMetaData.getHandleId());
        if (previousRevisionPair == null) {
            return;
        }
        ConfigurationItemRevision previousRevision = (ConfigurationItemRevision)previousRevisionPair.getFirst();
        Object previousDetails = this.repositoryService.getConfigurationItemDetailsObject(previousRevision.getId());
        ConfigurationItemMetaData previousMetaData = this.dtoFactory.createActualConfigurationItemMetaData(previousRevision, null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Copying previous CI details for handle ID = " + ciMetaData.getHandleId() + " from revision ID = " + previousRevision.getId()));
        }
        ConfigurationItemRevision revertedRevision = this.dtoFactory.createConfigurationItemRevision(previousMetaData, previousDetails);
        ConfigurationItemHandle handle = (ConfigurationItemHandle)this.configurationItemHandleDao.getById(Integer.valueOf(ciMetaData.getHandleId()));
        String label = ciMetaData.getLabel();
        String description = ciMetaData.getDescription();
        this.repositoryService.updateConfigurationItem(handle, label, description, revertedRevision);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Reverted configuration item \"" + ciMetaData.getLabel() + "\" of type " + ciMetaData.getConfigurationItemClassName() + ". It has handle ID " + ciMetaData.getHandleId() + "."));
        }
    }

    @Override
    public void validateAndImportDeploymentPackageOnServer(String packagePathOnServer) {
        HostSession lhs = HostSessionFactory.getHostSession((Host)Host.getLocalHost());
        this.deploymentPackageImportService.validateAndImport(lhs.getFile(packagePathOnServer));
    }

    @Override
    public void validateAndImportDeploymentPackageFromUrl(String url, String username, String password) {
        try {
            this.deploymentPackageImportService.validateAndImport(url, username, password);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public ChangePlanView findCurrentChangePlan() {
        ChangePlan cp;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Finding current change plan");
        }
        if ((cp = this.changePlanService.findCurrentChangePlan()) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Found no current change plan");
            }
            return null;
        }
        return this.dtoFactory.createChangePlanView(cp);
    }

    @Override
    public ChangePlanView resolveCurrentChangePlan() {
        ChangePlan cp;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Resolving current change plan.");
        }
        if ((cp = this.changePlanService.findCurrentChangePlan()) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Found no current change plan. Not resolving");
            }
            return null;
        }
        this.changePlanService.resolveChangePlan(cp);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolved current change plan with ID " + cp.getId()));
        }
        return this.dtoFactory.createChangePlanView(cp);
    }

    @Override
    public void executeAndCommitCurrentChangePlanASync() {
        ASyncChangePlanExecutor aSyncChangePlanExecutor = new ASyncChangePlanExecutor();
        aSyncChangePlanExecutor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAndCommitCurrentChangePlan() {
        ChangePlan cp;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Executing and committing current change plan.");
        }
        if ((cp = this.findResolvedCurrentChangePlan()) == null && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Found no current change plan. Not executing and committing");
        }
        this.changePlanService.checkThatChangePlanCanBeExecuted(cp);
        HashMap<String, Object> secAttributes = new HashMap<String, Object>();
        try {
            boolean firstTime = true;
            while (true) {
                if (!this.changePlanService.continueExecuteAndCommitOfCurrentChangePlan(firstTime, secAttributes)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Executed and committed current change plan with ID " + cp.getId()));
                    }
                    break;
                }
                firstTime = false;
            }
        }
        finally {
            for (Map.Entry secAttribute : secAttributes.entrySet()) {
                if (!(secAttribute.getValue() instanceof StepExecutionContextListener)) continue;
                try {
                    ((StepExecutionContextListener)secAttribute.getValue()).contextDestroyed();
                }
                catch (Exception exc) {
                    this.logger.error((Object)("Caught uncaught exception while destroying step execution context attribute " + (String)secAttribute.getKey()), (Throwable)exc);
                }
            }
        }
    }

    @Override
    public ChangePlanView skipAndCommitCurrentChangePlan() {
        ChangePlan cp;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Skipping and committing current change plan.");
        }
        if ((cp = this.findResolvedCurrentChangePlan()) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Found no current change plan. Not skipping and committing");
            }
            return null;
        }
        this.changePlanService.skipAndCommitChangePlan(cp);
        ChangePlanView changePlanView = this.dtoFactory.createChangePlanView(cp);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Skipped and committed current change plan with ID " + cp.getId()));
        }
        return changePlanView;
    }

    @Override
    public ChangePlanView abortCurrentChangePlan() {
        ChangePlan cp;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Aborting current change plan.");
        }
        if ((cp = this.changePlanService.findCurrentChangePlan()) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Found no current change plan. Not aborting");
            }
            return null;
        }
        this.changePlanService.abortChangePlan(cp);
        ChangePlanView changePlanView = this.dtoFactory.createChangePlanView(cp);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Aborted current change plan with ID " + cp.getId()));
        }
        return changePlanView;
    }

    @Override
    public ChangePlanView clearCurrentChangePlan() {
        ChangePlan cp;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Clearing current change plan.");
        }
        if ((cp = this.changePlanService.findCurrentChangePlan()) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Found no current change plan. Not clearing");
            }
            return null;
        }
        List<ConfigurationItemHandle> changedHandles = cp.getHandlesOfChangedCIs();
        for (ConfigurationItemHandle handle : changedHandles) {
            this.repositoryService.undoConfigurationItem(handle, true);
        }
        this.changePlanService.clearChangePlan(cp);
        ChangePlanView changePlanView = this.dtoFactory.createChangePlanView(cp);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Cleared current change plan with ID " + cp.getId()));
        }
        return changePlanView;
    }

    private ChangePlan findResolvedCurrentChangePlan() {
        ChangePlan cp = this.changePlanService.findCurrentChangePlan();
        if (cp == null) {
            return null;
        }
        if (!cp.isResolved()) {
            this.changePlanService.resolveChangePlan(cp);
        }
        return cp;
    }

    @Override
    public void addPauseStepsToCurrentChangePlan(Collection<Integer> positions) {
        ChangePlan cp = this.changePlanService.findCurrentChangePlan();
        if (cp == null) {
            throw new IllegalArgumentException("No current change plan");
        }
        this.changePlanService.addPauseStepsToChangePlan(cp, positions);
    }

    @Override
    public void skipStepsFromCurrentChangePlan(Collection<Integer> stepIds) {
        ChangePlan cp = this.changePlanService.findCurrentChangePlan();
        if (cp == null) {
            throw new IllegalArgumentException("No current change plan");
        }
        this.changePlanService.skipStepsInChangePlan(cp, stepIds);
    }

    @Override
    public void addPauseStepToCurrentChangePlan(int position) {
        ChangePlan cp = this.changePlanService.findCurrentChangePlan();
        if (cp == null) {
            throw new IllegalArgumentException("No current change plan");
        }
        this.changePlanService.addPauseStepToChangePlan(cp, position);
    }

    @Override
    public void removeStepFromCurrentChangePlan(int position) {
        ChangePlan cp = this.changePlanService.findCurrentChangePlan();
        if (cp == null) {
            throw new IllegalArgumentException("No current change plan");
        }
        this.changePlanService.removeStepFromChangePlan(cp, position);
    }

    @Override
    public void removeLoggingInformationOlderThan(Date date) {
        this.changePlanService.updateChangePlanOlderThan(date);
    }

    @Override
    public Collection<DeploymentPackageLocation> getAuthorisedDeploymentPackageList() {
        Collection<DeploymentPackageLocation> deploymentPackageLocations = this.deploymentPackageImportService.getDeploymentPackageList(this.configuration.getApplicationToDeployPath());
        return deploymentPackageLocations;
    }

    @Override
    public void shutdownServer() {
        this.serverManagementService.requestShutdown();
    }

    @Override
    public List<Map<Serializable, Serializable>> getDeploymentPerApplicationRecordsGridData(Date startDate, Date endDate, String applicationName) {
        return this.reportingService.getDeploymentPerApplicationRecordsGridData(startDate, endDate, applicationName);
    }

    @Override
    public List<List<Map<Serializable, Serializable>>> getDeploymentPerApplicationRecordsChartData(Date startDate, Date endDate, String applicationName) {
        return this.reportingService.getDeploymentPerApplicationRecordsChartData(startDate, endDate, applicationName);
    }

    @Override
    public List<String> getUsernamesAssociatedWithAnyChangePlan() {
        return this.changePlanService.findUsernamesAssociatedWithAnyChangePlan();
    }

    @Override
    public List<ChangePlan> getReportGridDataForChangePlanByUser(String user, Date startDate, Date endDate) {
        return this.reportingService.getReportGridDataForChangePlanByUser(user, startDate, endDate);
    }

    @Override
    public List<List<Map<Serializable, Serializable>>> getReportChartDataForChangePlanByUser(String user, Date startDate, Date endDate) {
        return this.reportingService.getReportChartDataForChangePlanByUser(user, startDate, endDate);
    }

    @Override
    public List<Map<Serializable, Serializable>> getReportGridDataForDeploymentsOnDomain(String wlsDomain, Date deploymentDate) {
        return this.reportingService.getReportGridDataForDeploymentsOnDomain(wlsDomain, deploymentDate);
    }

    @Override
    public List<Map<Serializable, Serializable>> getReportGridDataForDeploymentsOnEnvironment(String environment, Date deploymentDate) {
        return this.reportingService.getReportGridDataForDeploymentsOnEnvironment(environment, deploymentDate);
    }

    @Override
    public List<List<Map<Serializable, Serializable>>> getReportChartDataForFailedChangePlanByUser(String user, Date startDate, Date endDate) {
        return this.reportingService.getReportChartDataForFailedChangePlanByUser(user, startDate, endDate);
    }

    @Override
    public List<ChangePlan> getReportGridDataForFailedChangePlanByUser(String user, Date startDate, Date endDate) {
        return this.reportingService.getReportGridDataForFailedChangePlanByUser(user, startDate, endDate);
    }

    @Override
    public List<Map<Serializable, Serializable>> getGridDataForCiOfTypePerApplication(String ciType, String application) {
        return this.reportingService.getGridDataForCiOfTypePerApplication(ciType, application);
    }

    class ASyncChangePlanExecutor
    extends Thread {
        ASyncChangePlanExecutor() {
        }

        public void run() {
            AutomatedDeploymentServiceImpl.this.executeAndCommitCurrentChangePlan();
        }
    }
}

