/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.repository.metadata;

import com.xebia.ad.conversion.PropertyListConverter;
import com.xebia.ad.repository.factory.CiDetailsDeserializer;
import com.xebia.ad.repository.metadata.ConfigurationItemHandle;
import com.xebia.ad.repository.metadata.NamedConfigurationItemRelation;
import com.xebia.ad.repository.resolvers.RepositoryView;
import com.xebia.ad.support.Idable;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.DeployableArtifact;
import com.xebialabs.deployit.ci.security.PermissionScheme;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.ForeignKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="CI_REVISION")
@Inheritance(strategy=InheritanceType.JOINED)
public class ConfigurationItemRevision
implements Idable {
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    @ManyToOne(optional=true)
    @JoinColumn(name="HANDLE_ID")
    @ForeignKey(name="FK_CI_REVISION_HANDLE")
    private ConfigurationItemHandle handle;
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="PERMISSION_SCHEME_ID")
    @ForeignKey(name="CI_REVISION_PERMISSION_FK")
    private ConfigurationItemHandle permissionSchemeHandle;
    @Column(name="DETAILS", length=4096)
    @Lob
    private String serializedDetails;
    @OneToMany(mappedBy="owningRevision", cascade={CascadeType.ALL})
    private Set<NamedConfigurationItemRelation> namedConfigurationItemRelations;
    @Transient
    private Map<String, Set<ConfigurationItemHandle>> configurationItemRelations;
    private static Logger logger = Logger.getLogger(ConfigurationItemRevision.class);

    protected ConfigurationItemRevision() {
    }

    public ConfigurationItemRevision(Object configurationItemDetails) {
        this.setDetailsObject(configurationItemDetails);
    }

    public Set<ConfigurationItemHandle> getRelatedCiHandles(String propertyName) {
        HashSet relatedCiHandles;
        if (this.configurationItemRelations == null) {
            this.initializeConfigurationItemRelations();
        }
        return (relatedCiHandles = this.configurationItemRelations.get(propertyName)) != null ? relatedCiHandles : new HashSet();
    }

    public Set<ConfigurationItemHandle> getAllCiHandles() {
        HashSet<ConfigurationItemHandle> mergedSet = new HashSet<ConfigurationItemHandle>();
        if (this.configurationItemRelations == null) {
            this.initializeConfigurationItemRelations();
        }
        Collection<Set<ConfigurationItemHandle>> relatedCiHandles = this.configurationItemRelations.values();
        for (Set<ConfigurationItemHandle> set : relatedCiHandles) {
            mergedSet.addAll(set);
        }
        return mergedSet;
    }

    public ConfigurationItemHandle getRelatedCiHandle(String propertyName) {
        Set<ConfigurationItemHandle> handles = this.getRelatedCiHandles(propertyName);
        if (handles.isEmpty()) {
            return null;
        }
        if (handles.size() == 1) {
            return handles.iterator().next();
        }
        throw new AssertionError((Object)("Expected at most a single handle for property " + propertyName + " but found " + handles));
    }

    public void addRelatedCiHandle(String propertyName, ConfigurationItemHandle handle) {
        this.addRelatedCiHandles(propertyName, Collections.singleton(handle));
    }

    public void addRelatedCiHandles(String propertyName, Set<ConfigurationItemHandle> handles) {
        if (this.configurationItemRelations == null) {
            this.initializeConfigurationItemRelations();
        }
        if (!this.configurationItemRelations.containsKey(propertyName)) {
            this.configurationItemRelations.put(propertyName, new HashSet());
        }
        this.configurationItemRelations.get(propertyName).addAll(handles);
        for (ConfigurationItemHandle handle : handles) {
            this.namedConfigurationItemRelations.add(new NamedConfigurationItemRelation(this, propertyName, handle));
        }
    }

    private void initializeConfigurationItemRelations() {
        assert (this.configurationItemRelations == null);
        this.configurationItemRelations = new HashMap<String, Set<ConfigurationItemHandle>>();
        if (this.namedConfigurationItemRelations != null) {
            for (NamedConfigurationItemRelation relation : this.namedConfigurationItemRelations) {
                this.addRelationForInitialization(relation.getPropertyName(), relation.getTargetHandle());
            }
        } else {
            this.namedConfigurationItemRelations = new HashSet<NamedConfigurationItemRelation>();
        }
    }

    private void addRelationForInitialization(String propertyName, ConfigurationItemHandle handle) {
        if (!this.configurationItemRelations.containsKey(propertyName)) {
            this.configurationItemRelations.put(propertyName, new HashSet());
        }
        this.configurationItemRelations.get(propertyName).add(handle);
    }

    public void destroy() {
    }

    public void removeArtifactFiles() {
        String artifactPath;
        HostSession lhs;
        HostFile artifactFile;
        Serializable ciToBeDeleted = this.getDetailsObject(RepositoryView.getActualView());
        if (ciToBeDeleted instanceof DeployableArtifact && (artifactFile = (lhs = HostSessionFactory.getHostSession((Host)Host.getLocalHost())).getFile(artifactPath = ((DeployableArtifact)ciToBeDeleted).getLocation())).exists()) {
            logger.info((Object)("Removing artifact file " + artifactFile.getPath() + " because the revision will be removed"));
            artifactFile.deleteRecursively();
        }
    }

    public String getRevisionTypeName() {
        return "regular";
    }

    public boolean equals(Object thatObject) {
        if (thatObject instanceof ConfigurationItemRevision) {
            ConfigurationItemRevision that = (ConfigurationItemRevision)thatObject;
            if (this.getId() == 0 && that.getId() == 0) {
                return this == that;
            }
            return this.getId() == that.getId();
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == 0) {
            return System.identityHashCode(this);
        }
        return this.getId();
    }

    public String toString() {
        return "revision " + this.getId() + " of " + this.getRevisionTypeName() + " " + this.handle;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public ConfigurationItemHandle getHandle() {
        return this.handle;
    }

    public void setHandle(ConfigurationItemHandle handle) {
        handle.addRevision(this);
    }

    public void internalSetHandle(ConfigurationItemHandle handle) {
        this.handle = handle;
    }

    public String getType() {
        return this.getHandle().getType();
    }

    public boolean isOfType(String type) {
        return this.getType().equals(type);
    }

    public ConfigurationItemHandle getPermissionSchemeHandle() {
        return this.permissionSchemeHandle;
    }

    public void setPermissionSchemeHandle(ConfigurationItemHandle permissionSchemeHandle) {
        this.permissionSchemeHandle = permissionSchemeHandle;
    }

    public PermissionScheme getPermissionScheme() {
        ConfigurationItemHandle permissionSchemeHandle = this.getPermissionSchemeHandle();
        if (permissionSchemeHandle == null) {
            return null;
        }
        if (!permissionSchemeHandle.getType().equals(PermissionScheme.class.getName())) {
            throw new IllegalArgumentException("Permission scheme handle " + permissionSchemeHandle.getId() + " for " + this + " does not point to a PermissionScheme CI");
        }
        ConfigurationItemRevision actualPermissionScheme = permissionSchemeHandle.getActualRevision();
        if (actualPermissionScheme == null) {
            return null;
        }
        PermissionScheme scheme = (PermissionScheme)actualPermissionScheme.getDetailsObject(RepositoryView.getActualView());
        return scheme;
    }

    public Serializable getDetailsObject(RepositoryView view) {
        return (Serializable)CiDetailsDeserializer.getInstance().deserialize(this, this.getType(), this.serializedDetails, view);
    }

    public void setDetailsObject(Object ci) {
        this.serializedDetails = PropertyListConverter.convertObjectToString(ci);
    }

    public void setNamedConfigurationItemRelations(Set<NamedConfigurationItemRelation> namedConfigurationItemRelations) {
        this.namedConfigurationItemRelations = namedConfigurationItemRelations;
    }

    public Set<NamedConfigurationItemRelation> getNamedConfigurationItemRelations() {
        return this.namedConfigurationItemRelations;
    }
}

