/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.repository.metadata;

import com.xebia.ad.repository.metadata.Change;
import com.xebia.ad.repository.metadata.ConfigurationItemRevision;
import com.xebia.ad.support.Idable;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="CI_HANDLE")
@NamedQueries(value={@NamedQuery(name="getActuals", query="SELECT handle FROM ConfigurationItemHandle handle where handle.actualRevision is not null"), @NamedQuery(name="getHandle", query="SELECT handle FROM ConfigurationItemHandle handle where handle.label = :label")})
public class ConfigurationItemHandle
implements Idable,
Serializable {
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    @Column(name="LABEL")
    @Index(name="CI_HANDLE_LABEL_UN")
    private String label;
    @Column(name="DESCRIPTION", length=4096)
    @Lob
    private String description;
    @Column(name="TYPE")
    private String type;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="ACTUAL_REVISION_ID")
    @ForeignKey(name="CI_HANDLE_ACTUAL_REVISION_FK")
    @Index(name="CI_HANDLE_ACTUAL_REVISION_IX")
    private ConfigurationItemRevision actualRevision;
    @OneToMany(mappedBy="handle", cascade={}, fetch=FetchType.LAZY)
    private Set<Change> changes = new HashSet<Change>();

    public ConfigurationItemHandle() {
    }

    public ConfigurationItemHandle(String type) {
        this.type = type;
    }

    public ConfigurationItemHandle(String label, String type, ConfigurationItemRevision firstRevision) {
        this.setLabel(label);
        this.type = type;
        this.addRevision(firstRevision);
    }

    public ConfigurationItemHandle(String type, ConfigurationItemRevision firstRevision) {
        this.type = type;
        this.addRevision(firstRevision);
    }

    public void destroy() {
    }

    public String getType() {
        return this.type;
    }

    public Class<?> getItemClass() {
        try {
            return Class.forName(this.getType());
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException("Unable to load item class " + this.getType() + " for handle " + this.label);
        }
    }

    public void moveToAttic() {
        this.label = this.label + " NB now deleted. Deletion timestamp: " + System.currentTimeMillis();
    }

    public boolean equals(Object thatObject) {
        if (thatObject instanceof ConfigurationItemHandle) {
            ConfigurationItemHandle that = (ConfigurationItemHandle)thatObject;
            if (this.getId() == 0 && that.getId() == 0) {
                return this == that;
            }
            return this.getId() == that.getId();
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == 0) {
            return System.identityHashCode(this);
        }
        return this.getId();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("configuration item ");
        if (this.label != null) {
            buf.append("\"");
            buf.append(this.label);
            buf.append("\" (id=");
            buf.append(this.id);
            buf.append(")");
        } else {
            buf.append("<unnamed>");
            buf.append(" (id=");
            buf.append(this.id);
            buf.append(")");
        }
        return buf.toString();
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ConfigurationItemRevision getActualRevision() {
        return this.actualRevision;
    }

    public void setActualRevision(ConfigurationItemRevision actualRevision) {
        this.actualRevision = actualRevision;
    }

    public void addRevision(ConfigurationItemRevision revisionToAdd) {
        revisionToAdd.internalSetHandle(this);
    }

    public void removeRevision(ConfigurationItemRevision revisionToRemove) {
        revisionToRemove.internalSetHandle(null);
    }

    public Set<Change> getChanges() {
        return this.changes;
    }
}

