/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.repository.metadata;

import com.xebia.ad.plugin.DelegatingJythonRunBook;
import com.xebia.ad.repository.metadata.Change;
import com.xebia.ad.repository.metadata.ChangePlanAdapter;
import com.xebia.ad.repository.metadata.ChangePlanState;
import com.xebia.ad.repository.metadata.ConfigurationItemHandle;
import com.xebia.ad.repository.metadata.RunBookRegistry;
import com.xebia.ad.repository.metadata.Step;
import com.xebia.ad.repository.metadata.StepAdapter;
import com.xebia.ad.repository.metadata.StepContainer;
import com.xebia.ad.repository.metadata.StepState;
import com.xebia.ad.repository.resolvers.RepositoryView;
import com.xebia.ad.service.AutomatedDeploymentListener;
import com.xebia.ad.support.Idable;
import com.xebia.ad.support.IdableComparator;
import com.xebia.ad.support.Positionable;
import com.xebia.ad.support.PositionableComparator;
import com.xebia.ad.support.PositionableUtils;
import com.xebialabs.deployit.ChangeResolution;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.RunBook;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.SortType;
import org.python.core.PyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="CHANGEPLAN")
public class ChangePlan {
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private int id;
    @Column(name="USERNAME")
    @Index(name="CHANGEPLAN_USERNAME_IX")
    private String username;
    @Column(name="STATE")
    @Enumerated(value=EnumType.STRING)
    @Index(name="CHANGEPLAN_STATE_IX")
    private ChangePlanState state = ChangePlanState.EMPTY;
    @Column(name="RESOLUTION_ERROR", length=255)
    private String resolutionError = "";
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="START_OF_EXECUTION")
    private Date startOfExecution;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="END_OF_EXECUTION")
    private Date endOfExecution;
    @OneToMany(mappedBy="changePlan", fetch=FetchType.LAZY)
    @Sort(type=SortType.COMPARATOR, comparator=IdableComparator.class)
    private SortedSet<Change> changes = new TreeSet<Idable>(new IdableComparator());
    private transient Queue<Runnable> queuedChangesOperations = new LinkedList<Runnable>();
    @OneToMany(mappedBy="changePlan", fetch=FetchType.LAZY)
    @MapKey(name="handle")
    private Map<ConfigurationItemHandle, Change> changesByHandle = new HashMap<ConfigurationItemHandle, Change>();
    private transient Queue<Runnable> queuedChangesByHandleOperations = new LinkedList<Runnable>();
    @OneToMany(mappedBy="changePlan", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Sort(type=SortType.COMPARATOR, comparator=PositionableComparator.class)
    private SortedSet<StepContainer> stepContainers = new TreeSet<Positionable>(new PositionableComparator());
    private transient Queue<Runnable> queuedStepContainersOperations = new LinkedList<Runnable>();
    private static Logger logger = Logger.getLogger(ChangePlan.class);

    public RepositoryView getDesignView() {
        return RepositoryView.getDesignView(this);
    }

    public void addChange(Change changeToAdd) {
        assert (changeToAdd.getChangePlan() == null);
        changeToAdd.internalSetChangePlan(this);
        this.internalAddChange(changeToAdd);
        this.unresolve();
    }

    private void internalAddChange(final Change changeToAdd) {
        this.queuedChangesOperations.add(new Runnable(){

            public void run() {
                ChangePlan.this.changes.add(changeToAdd);
            }
        });
        this.queuedChangesByHandleOperations.add(new Runnable(){

            public void run() {
                ChangePlan.this.changesByHandle.put(changeToAdd.getHandle(), changeToAdd);
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Postponed addition to changes set and changesByHandle map");
        }
    }

    public void removeChange(Change changeToRemove) {
        assert (changeToRemove.getChangePlan() == this);
        changeToRemove.internalSetChangePlan(null);
        this.internalRemoveChange(changeToRemove);
        this.unresolve();
    }

    private void internalRemoveChange(final Change changeToRemove) {
        this.queuedChangesOperations.add(new Runnable(){

            public void run() {
                ChangePlan.this.changes.remove(changeToRemove);
            }
        });
        this.queuedChangesByHandleOperations.add(new Runnable(){

            public void run() {
                ChangePlan.this.changesByHandle.size();
                ChangePlan.this.changesByHandle.remove(changeToRemove.getHandle());
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Postponed removal from changes set and changesByHandle map");
        }
    }

    public SortedSet<Change> getChanges() {
        this.executeQueuedChangesOperations();
        return Collections.unmodifiableSortedSet(this.changes);
    }

    private void executeQueuedChangesOperations() {
        this.executeQueuedOperations(this.queuedChangesOperations, "changes set");
    }

    public Change findChangeByHandle(ConfigurationItemHandle handle) {
        this.executeQueuedChangesByHandleOperations();
        return this.changesByHandle.get(handle);
    }

    private void executeQueuedChangesByHandleOperations() {
        this.executeQueuedOperations(this.queuedChangesByHandleOperations, "changesByHandle map");
    }

    private void unresolve() {
        if (this.canBeResolved()) {
            this.setState(ChangePlanState.UNRESOLVED);
            this.setResolutionError("");
        }
    }

    public void resolve(RunBookRegistry runBookFactoryRegistry) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resolving " + this));
        }
        this.stepContainers.clear();
        if (!this.getChanges().isEmpty()) {
            this.unresolve();
            try {
                this.resolveWithRunBooks(runBookFactoryRegistry);
                this.markResolved();
            }
            catch (ResolutionException exc) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Got resolution exception while resolving " + this), (Throwable)exc);
                }
                this.setResolutionError(StringUtils.abbreviate((String)exc.getMessage(), (int)255));
            }
            catch (Exception exc) {
                logger.error((Object)"Unexpected exception resolving ", (Throwable)exc);
                this.setResolutionError(StringUtils.abbreviate((String)("Unexpected exception resolving: " + exc.getMessage()), (int)255));
            }
        } else {
            this.setState(ChangePlanState.EMPTY);
        }
    }

    public void resolveWithRunBooks(RunBookRegistry runBookFactoryRegistry) {
        Collection<RunBook> runbooks = runBookFactoryRegistry.getRunBooks();
        for (RunBook each : runbooks) {
            try {
                Collection resolutions;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Asking \"" + ChangePlan.getRunBookName(each) + "\" to resolve"));
                }
                if ((resolutions = each.resolve((com.xebialabs.deployit.ChangePlan)new ChangePlanAdapter(this))) == null) {
                    logger.error((Object)("Run book " + ChangePlan.getRunBookName(each) + " returned null when asked to resolve. Ignoring it."));
                    continue;
                }
                int nrOfChangesHandledByThisRunBook = 0;
                int nrOfStepsFromThisRunBook = 0;
                for (ChangeResolution eachCR : resolutions) {
                    nrOfChangesHandledByThisRunBook += eachCR.getChanges().size();
                    nrOfStepsFromThisRunBook += eachCR.getSteps().size();
                    for (com.xebialabs.deployit.Step eachStep : eachCR.getSteps()) {
                        if (eachStep instanceof Step) {
                            this.addStep((Step)eachStep);
                            continue;
                        }
                        this.addStep(new StepAdapter(eachStep));
                    }
                }
                logger.info((Object)("Run book \"" + ChangePlan.getRunBookName(each) + "\" has resolved and returned " + resolutions.size() + " resolutions for " + nrOfChangesHandledByThisRunBook + " changes with " + nrOfStepsFromThisRunBook + " steps"));
            }
            catch (PyException exc) {
                String message = "Jython run book " + ChangePlan.getRunBookName(each) + " threw an exception: " + DelegatingJythonRunBook.getPythonErrorMessage(exc);
                logger.info((Object)message);
                throw new ResolutionException(message);
            }
            catch (Exception exc) {
                String message = "Run book \"" + ChangePlan.getRunBookName(each) + "\" threw an exception: " + exc;
                logger.info((Object)message);
                if (logger.isDebugEnabled()) {
                    StringWriter sink = new StringWriter();
                    exc.printStackTrace(new PrintWriter(sink));
                    logger.debug((Object)sink.toString());
                }
                throw new ResolutionException(message);
            }
        }
    }

    public void markResolved() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Marking changeplan as resolved");
        }
        this.setState(ChangePlanState.PENDING);
    }

    public boolean canBeResolved() {
        return !this.isExecuting();
    }

    public boolean isResolved() {
        return this.getState() != ChangePlanState.UNRESOLVED;
    }

    public boolean isPending() {
        return this.getState() == ChangePlanState.PENDING || this.getState() == ChangePlanState.ABORTED || this.getState() == ChangePlanState.PAUSED || this.getState() == ChangePlanState.FAILED;
    }

    public boolean isExecuting() {
        return this.getState() == ChangePlanState.EXECUTING;
    }

    public boolean isFinished() {
        return this.getState() == ChangePlanState.CLEARED || this.getState() == ChangePlanState.SKIPPED || this.getState() == ChangePlanState.DONE;
    }

    public void abort(AutomatedDeploymentListener listener) {
        if (this.isExecuting()) {
            this.setState(ChangePlanState.ABORTED);
            if (listener != null) {
                listener.changePlanUpdated(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipAndCommit(AutomatedDeploymentListener listener) {
        if (!this.isPending()) {
            return;
        }
        this.start(null);
        try {
            for (StepContainer eachStepContainer : this.getStepContainers()) {
                Step eachStep = eachStepContainer.getStep();
                eachStep.skip();
            }
        }
        finally {
            this.setState(ChangePlanState.SKIPPED);
            this.commit(listener);
            this.finish(listener);
        }
    }

    public List<ConfigurationItemHandle> getHandlesOfChangedCIs() {
        ArrayList<ConfigurationItemHandle> changedHandles = new ArrayList<ConfigurationItemHandle>();
        for (Change c : this.getChanges()) {
            changedHandles.add(c.getHandle());
        }
        return changedHandles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(AutomatedDeploymentListener listener) {
        if (this.isExecuting() || this.isFinished()) {
            return;
        }
        this.start(null);
        try {
            for (StepContainer eachStepContainer : this.getStepContainers()) {
                Step eachStep = eachStepContainer.getStep();
                eachStep.skip();
            }
        }
        finally {
            this.setState(ChangePlanState.CLEARED);
            this.finish(listener);
        }
    }

    public boolean continueExecuteAndCommit(AutomatedDeploymentListener listener, Map<String, Object> secAttributes, boolean firstTime) {
        switch (this.getState()) {
            case UNRESOLVED: {
                throw new IllegalStateException("Cannot execute change plan because it was not resolved. " + this.getResolutionError());
            }
            case ABORTED: 
            case FAILED: 
            case PAUSED: {
                if (!firstTime) {
                    return false;
                }
            }
            case PENDING: {
                this.start(listener);
            }
            case EXECUTING: {
                return this.advanceStepExecution(listener, secAttributes, firstTime);
            }
        }
        return false;
    }

    private boolean advanceStepExecution(AutomatedDeploymentListener listener, Map<String, Object> secAttributes, boolean firstTime) {
        block10: for (StepContainer sc : this.getStepContainers()) {
            Step s = sc.getStep();
            switch (s.getState()) {
                case FAILED: {
                    return false;
                }
                case PENDING: {
                    s.startExecute(listener);
                    return true;
                }
                case EXECUTING: {
                    if (firstTime) {
                        logger.warn((Object)("Trying to execute a step that is already being executed (step " + s.getId() + " has state " + (Object)((Object)StepState.EXECUTING) + " and firstTime=" + firstTime));
                    }
                    s.execute(listener, secAttributes);
                    if (this.getState() == ChangePlanState.EXECUTING) {
                        switch (s.getState()) {
                            case PAUSED: {
                                this.setState(ChangePlanState.PAUSED);
                                break;
                            }
                            case DONE: {
                                break;
                            }
                            default: {
                                this.setState(ChangePlanState.FAILED);
                            }
                        }
                    }
                    return true;
                }
                case PAUSED: {
                    s.setState(StepState.DONE);
                    continue block10;
                }
            }
        }
        if (this.getState() != ChangePlanState.DONE) {
            this.setState(ChangePlanState.DONE);
            this.commit(listener);
            this.finish(listener);
            return true;
        }
        return false;
    }

    private void start(AutomatedDeploymentListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting execution of " + this));
        }
        this.setState(ChangePlanState.EXECUTING);
        if (this.getStartOfExecution() == null) {
            this.setStartOfExecution(new Date());
        }
        for (StepContainer sc : this.getStepContainers()) {
            Step s = sc.getStep();
            if (s.getState() != StepState.FAILED) continue;
            s.setState(StepState.PENDING);
        }
        if (listener != null) {
            listener.changePlanUpdated(this);
        }
    }

    private void commit(AutomatedDeploymentListener listener) {
        for (Change c : this.getChanges()) {
            c.getHandle().setActualRevision(c.getNewRevision());
            if (listener != null) {
                listener.changeCommitted(c);
            }
            if (c.getOldRevision() == null || c.getNewRevision() != null) continue;
            c.getHandle().moveToAttic();
        }
    }

    private void finish(AutomatedDeploymentListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Completing execution of " + this));
        }
        if (this.getState() == ChangePlanState.DONE || this.getState() == ChangePlanState.SKIPPED) {
            this.setEndOfExecution(new Date());
        }
        if (listener != null) {
            listener.changePlanUpdated(this);
        }
    }

    public String toString() {
        return "ChangePlan #" + this.getId() + " for " + this.getUsername();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public ChangePlanState getState() {
        return this.state;
    }

    public void setState(ChangePlanState state) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting state of " + this + " to " + (Object)((Object)state)));
        }
        this.state = state;
    }

    public String getResolutionError() {
        return this.resolutionError;
    }

    public void setResolutionError(String resolutionError) {
        this.resolutionError = resolutionError;
    }

    public Date getStartOfExecution() {
        return this.startOfExecution;
    }

    public void setStartOfExecution(Date startOfExecution) {
        this.startOfExecution = startOfExecution;
    }

    public Date getEndOfExecution() {
        return this.endOfExecution;
    }

    public void setEndOfExecution(Date endOfExecution) {
        this.endOfExecution = endOfExecution;
    }

    private SortedSet<StepContainer> getStepContainers() {
        this.executeQueuedStepContainersOperations();
        return this.stepContainers;
    }

    private void executeQueuedStepContainersOperations() {
        this.executeQueuedOperations(this.queuedStepContainersOperations, "stepContainers set");
    }

    public List<Step> getSteps() {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (StepContainer each : this.getStepContainers()) {
            Step eachStep = each.getStep();
            steps.add(eachStep);
        }
        return steps;
    }

    private boolean containsStep(Step step) {
        for (StepContainer each : this.getStepContainers()) {
            Step eachStep = each.getStep();
            if (!eachStep.equals(step)) continue;
            return true;
        }
        return false;
    }

    public Step findStep(int stepId) {
        for (StepContainer each : this.getStepContainers()) {
            if (each.getId() != stepId) continue;
            return each.getStep();
        }
        return null;
    }

    public boolean isUnSkippableStep(int stepId) {
        StepContainer correspondingContainer = null;
        for (StepContainer each : this.getStepContainers()) {
            if (each.getId() != stepId) continue;
            correspondingContainer = each;
            break;
        }
        if (correspondingContainer == null) {
            return false;
        }
        StepContainer nextStepToExecute = this.findNextStepToExecute();
        return correspondingContainer.getPosition() > nextStepToExecute.getPosition();
    }

    public StepContainer findNextStepToExecute() {
        for (StepContainer each : this.getStepContainers()) {
            if (each.getState() != StepState.PENDING && each.getState() != StepState.PAUSED && each.getState() != StepState.FAILED) continue;
            return each;
        }
        return null;
    }

    public void addStep(Step stepToAdd) {
        if (this.containsStep(stepToAdd)) {
            throw new ResolutionException(this.getSteps() + " already contains the instance " + stepToAdd);
        }
        StepContainer stepContainerToAdd = stepToAdd.getStepContainer();
        PositionableUtils.setPosition(this.stepContainers, stepContainerToAdd);
        stepContainerToAdd.internalSetChangePlan(this);
        stepContainerToAdd.serializeStep();
        this.stepContainers.add(stepContainerToAdd);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Postponed addition to stepContainers set");
        }
    }

    public void addSteps(List<Step> stepsToAdd) {
        for (Step s : stepsToAdd) {
            this.addStep(s);
        }
    }

    public void removeStep(Step stepToRemove) {
        StepContainer stepContainerToRemove = stepToRemove.getStepContainer();
        this.remoteStepContainer(stepContainerToRemove);
    }

    public void removeStepByPosition(int position) {
        for (StepContainer eachStepContainer : this.stepContainers) {
            if (eachStepContainer.getPosition() != position) continue;
            this.remoteStepContainer(eachStepContainer);
            break;
        }
    }

    private void remoteStepContainer(StepContainer stepContainerToRemove) {
        stepContainerToRemove.internalSetChangePlan(null);
        this.stepContainers.remove(stepContainerToRemove);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Could not postpone removal from stepContainers set");
        }
    }

    public void removeAllSteps() {
        this.stepContainers.clear();
        this.queuedStepContainersOperations.clear();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Cleared queue of postponed operations on stepContainers set");
        }
    }

    public static String getRunBookName(RunBook rb) {
        return rb instanceof DelegatingJythonRunBook ? ((DelegatingJythonRunBook)rb).getJythonScriptPath() : rb.getClass().getName();
    }

    private void executeQueuedOperations(Queue<Runnable> queuedOperations, String description) {
        Runnable op;
        while ((op = queuedOperations.poll()) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing queued operations on " + description));
            }
            op.run();
        }
    }
}

