/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.plugin;

import com.xebia.ad.plugin.DelegatingJythonRunBook;
import com.xebia.ad.repository.ConfigurationItemTypeDescriptorRepository;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.exception.RuntimeIOException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginLoader {
    public static final String CONFIGURATION_ITEM_ATTRIBUTE_NAME = "ConfigurationItem";
    public static final String RUN_BOOK_ATTRIBUTE_NAME = "RunBook";
    public static final String DISABLED_RUN_BOOKS_ATTRIBUTE_NAME = "Disabled-RunBooks";
    @Autowired
    public ConfigurationItemTypeDescriptorRepository repository;
    private final ClassLoader pluginClassLoader;
    private final Set<String> runbookEntryNames = new HashSet<String>();
    private final Set<String> configurationItemEntryNames = new HashSet<String>();
    private final Set<String> runbookEntryNamesToDisable = new HashSet<String>();
    private final Collection<RunBook> runbooks = new ArrayList<RunBook>();
    private final Collection<Class<?>> configurationItemTypes = new ArrayList();
    private final List<String> loadingErrors = new ArrayList<String>();
    private Logger logger = Logger.getLogger(PluginLoader.class);

    public PluginLoader(ClassLoader classLoader) {
        this.pluginClassLoader = classLoader;
    }

    public PluginLoader() {
        this(PluginLoader.class.getClassLoader());
    }

    public void loadPlugins() {
        this.scanManifests();
        this.disableEntries();
        this.loadEntries();
    }

    public void loadPluginsWithoutDisabling() {
        this.scanManifests();
        this.loadEntries();
    }

    private void scanManifests() {
        try {
            Enumeration<URL> resources = this.pluginClassLoader.getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL manifestURL = resources.nextElement();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Loading manifest file " + manifestURL));
                }
                this.readManifest(manifestURL);
            }
        }
        catch (IOException exc) {
            throw new RuntimeIOException((Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readManifest(URL manifestURL) throws IOException {
        InputStream manifestInput = manifestURL.openStream();
        try {
            Manifest manifest = new Manifest(manifestInput);
            this.logger.info((Object)("Reading manifest " + manifestURL));
            this.readManifestMainAttributes(manifest);
            Map<String, Attributes> entries = manifest.getEntries();
            for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
                this.readManifestEntry(entry);
            }
        }
        finally {
            manifestInput.close();
        }
    }

    private void readManifestMainAttributes(Manifest manifest) {
        String disabledRunbookEntryNamesAttrValue = manifest.getMainAttributes().getValue(DISABLED_RUN_BOOKS_ATTRIBUTE_NAME);
        if (disabledRunbookEntryNamesAttrValue != null) {
            String[] disabledRunbookEntryNames = StringUtils.split((String)disabledRunbookEntryNamesAttrValue);
            this.runbookEntryNamesToDisable.addAll(Arrays.asList(disabledRunbookEntryNames));
        }
    }

    private void readManifestEntry(Map.Entry<String, Attributes> entry) {
        String entryName = entry.getKey();
        Attributes attributes = entry.getValue();
        if ("true".equalsIgnoreCase(attributes.getValue(RUN_BOOK_ATTRIBUTE_NAME))) {
            this.runbookEntryNames.add(entryName);
        } else if ("true".equalsIgnoreCase(attributes.getValue(CONFIGURATION_ITEM_ATTRIBUTE_NAME))) {
            this.configurationItemEntryNames.add(entryName);
        } else {
            this.logger.debug((Object)("Ignoring entry " + entryName + " because it is not a RunBook or a ConfigurationItem"));
        }
    }

    private void disableEntries() {
        for (String each : this.runbookEntryNamesToDisable) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Disabling run book " + each));
            }
            this.runbookEntryNames.remove(each);
        }
    }

    private void loadEntries() {
        this.loadRunBooks();
        this.loadConfigurationItems();
        this.repository.loadConfigurationItems(this.getConfigurationItemTypes());
    }

    private void loadRunBooks() {
        for (String each : this.runbookEntryNames) {
            if (each.endsWith(".class")) {
                this.loadJavaRunBook(each);
                continue;
            }
            if (each.endsWith(".py")) {
                this.loadPythonRunBook(each);
                continue;
            }
            this.reportError(each + " is declared as a run book factory but is not a Java class or a Python file");
        }
    }

    private void loadJavaRunBook(String entryName) {
        String javaClassName = PluginLoader.convertEntryNameToJavaClassName(entryName);
        try {
            RunBook runbook = (RunBook)Class.forName(javaClassName).newInstance();
            this.runbooks.add(runbook);
            this.logger.info((Object)("Loaded Java run book " + javaClassName));
        }
        catch (Exception exc) {
            this.reportError("Cannot load Java run book " + javaClassName, exc);
        }
    }

    private void loadPythonRunBook(String entryName) {
        try {
            DelegatingJythonRunBook runbook = new DelegatingJythonRunBook(this.pluginClassLoader, entryName);
            this.runbooks.add(runbook);
            this.logger.info((Object)("Loaded Jython run book " + entryName));
        }
        catch (Exception exc) {
            this.reportError("Cannot load Jython run book " + entryName, exc);
        }
    }

    private void loadConfigurationItems() {
        for (String each : this.configurationItemEntryNames) {
            if (each.endsWith(".class")) {
                this.loadJavaConfigurationItem(each);
                continue;
            }
            this.reportError(each + " is declared as a configuration item but is not a Java class");
        }
    }

    private void loadJavaConfigurationItem(String entryName) {
        String javaClassName = PluginLoader.convertEntryNameToJavaClassName(entryName);
        try {
            this.configurationItemTypes.add(Class.forName(javaClassName));
            this.logger.info((Object)("Loaded Java configuration item " + javaClassName));
        }
        catch (Exception exc) {
            this.reportError("Cannot load Java configuration item " + javaClassName, exc);
        }
    }

    private static String convertEntryNameToJavaClassName(String each) {
        return StringUtils.removeEnd((String)each, (String)".class").replace('/', '.');
    }

    private void reportError(String errorMessage, Exception exc) {
        this.logger.error((Object)errorMessage, (Throwable)exc);
        this.loadingErrors.add(errorMessage + ": " + exc.toString());
    }

    private void reportError(String errorMessage) {
        this.logger.error((Object)errorMessage);
        this.loadingErrors.add(errorMessage);
    }

    public Collection<RunBook> getRunBooks() {
        return this.runbooks;
    }

    public Collection<Class<?>> getConfigurationItemTypes() {
        return this.configurationItemTypes;
    }

    public List<String> getLoadingErrors() {
        return Collections.unmodifiableList(this.loadingErrors);
    }
}

