/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.conversion;

import com.xebia.ad.conversion.AttributePair;
import com.xebia.ad.conversion.ConversionException;
import com.xebia.ad.conversion.StringCoder;
import com.xebialabs.deployit.mapper.Pair;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemDescriptorFactory;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyDescriptor;
import com.xebialabs.deployit.reflect.ConfigurationItemPropertyType;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyListConverter {
    private static final int START = 0;
    private static final int READING_A_QUOTED_STRING = 1;
    private static final int READING_AN_ESCAPED_CHARACTER_IN_A_QUOTED_STRING = 2;
    private static final int READING_A_WORD = 3;
    private static final int READING_A_MEMBER_OPERATOR = 4;
    private static Logger logger = Logger.getLogger(PropertyListConverter.class);

    public static void populateMap(Map<String, Object> mapToPopulate, String serializedDetails, ConfigurationItemPropertyDescriptor[] propertyDescriptors) throws ConversionException {
        Map<String, String> attributes = PropertyListConverter.tokenizeAndCreateMapFromString(serializedDetails);
        PropertyListConverter.populateMap(attributes, mapToPopulate, propertyDescriptors);
    }

    public static void populateMap(Map<String, String> attributes, Map<String, Object> mapToPopulate, ConfigurationItemPropertyDescriptor[] propertyDescriptors) throws ConversionException {
        for (ConfigurationItemPropertyDescriptor pd : propertyDescriptors) {
            String stringValue = attributes.get(pd.getName().toLowerCase());
            if (stringValue == null) continue;
            Object value = null;
            switch (pd.getType()) {
                case STRING: 
                case INTEGER: 
                case BOOLEAN: 
                case ENUM: {
                    value = stringValue;
                    break;
                }
                case LIST_OF_OBJECTS: {
                    value = PropertyListConverter.stringToListOfMaps(pd, stringValue);
                }
            }
            if (value == null) continue;
            mapToPopulate.put(pd.getName(), value);
        }
    }

    public static List<Map<String, Object>> stringToListOfMaps(ConfigurationItemPropertyDescriptor descriptor, String value) throws ConversionException {
        ArrayList<Map<String, Object>> theList = new ArrayList<Map<String, Object>>();
        String singleMember = null;
        while ((singleMember = PropertyListConverter.readUntilClosingSquareBracket(value)) != null) {
            HashMap<String, Object> member;
            String[] subTokens;
            value = value.substring(singleMember.length(), value.length());
            if ((value = value.trim()).startsWith(",")) {
                value = value.substring(1, value.length());
                value = value.trim();
            }
            if ((subTokens = PropertyListConverter.tokenize(singleMember = PropertyListConverter.stripOpenAndClosingBrackets(singleMember))).length <= 0) continue;
            try {
                member = new HashMap<String, Object>();
                Map<String, String> singleMemberAsAttributes = PropertyListConverter.tokenizeAndCreateMapFromString(singleMember);
                PropertyListConverter.populateMap(singleMemberAsAttributes, member, descriptor.getListObjectPropertyDescriptors());
            }
            catch (ConversionException e) {
                throw new IllegalArgumentException("Cannot convert " + value + " into a list of objects");
            }
            theList.add(member);
        }
        return theList;
    }

    public static void populateObject(Object objectToPopulate, String serializedDetails, ConfigurationItemPropertyDescriptor[] propertyDescriptors) throws ConversionException {
        Map<String, String> attributes = PropertyListConverter.tokenizeAndCreateMapFromString(serializedDetails);
        PropertyListConverter.populateObject(attributes, objectToPopulate, propertyDescriptors);
    }

    public static Object convertStringToObject(String serializedDetails, ConfigurationItemDescriptor descriptor) throws ConversionException {
        Map<String, String> attributes = PropertyListConverter.tokenizeAndCreateMapFromString(serializedDetails);
        Object objectToPopulate = PropertyListConverter.newObjectInstanceFromDescriptor(descriptor);
        PropertyListConverter.populateObject(attributes, objectToPopulate, descriptor.getPropertyDescriptors());
        return objectToPopulate;
    }

    public static Object convertAttributesToObject(Map<String, String> attributes, ConfigurationItemDescriptor descriptor) throws ConversionException {
        Object objectToPopulate = PropertyListConverter.newObjectInstanceFromDescriptor(descriptor);
        PropertyListConverter.populateObject(attributes, objectToPopulate, descriptor.getPropertyDescriptors());
        return objectToPopulate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void populateObject(Map<String, String> attributes, Object objectToPopulate, ConfigurationItemPropertyDescriptor[] propertyDescriptors) throws ConversionException {
        try {
            for (ConfigurationItemPropertyDescriptor pd : propertyDescriptors) {
                Object value;
                Field propertyField = pd.getPropertyField();
                String stringValue = attributes.get(pd.getName().toLowerCase());
                if (stringValue == null) continue;
                if (ConfigurationItemPropertyType.STRING.equals((Object)pd.getType())) {
                    value = pd.isPassword() ? StringCoder.decode(stringValue) : stringValue;
                } else if (ConfigurationItemPropertyType.INTEGER.equals((Object)pd.getType())) {
                    value = Integer.parseInt(stringValue);
                } else if (ConfigurationItemPropertyType.BOOLEAN.equals((Object)pd.getType())) {
                    value = Boolean.parseBoolean(stringValue);
                } else if (ConfigurationItemPropertyType.ENUM.equals((Object)pd.getType())) {
                    Enum[] enumConstants;
                    value = null;
                    for (Enum eachEnumConstant : enumConstants = (Enum[])pd.getPropertyClass().getEnumConstants()) {
                        if (!stringValue.equalsIgnoreCase(eachEnumConstant.name())) continue;
                        value = eachEnumConstant;
                        break;
                    }
                    if (value == null) {
                        throw new ConversionException("Cannot convert value \"" + stringValue + "\" to enum of type " + pd.getPropertyClassname());
                    }
                } else if (ConfigurationItemPropertyType.LIST_OF_OBJECTS.equals((Object)pd.getType()) || ConfigurationItemPropertyType.SET_OF_STRINGS.equals((Object)pd.getType())) {
                    Class propertyClass = pd.getPropertyClass();
                    if (propertyClass.isAssignableFrom(List.class)) {
                        value = PropertyListConverter.stringToList(pd, stringValue);
                    } else {
                        if (!propertyClass.isAssignableFrom(Set.class) || !pd.getCollectionMemberClass().isAssignableFrom(String.class)) throw new ConversionException("Collection " + pd.getPropertyClassname() + " is not supported");
                        Set<String> theSet = PropertyListConverter.stringToSetOfStrings(stringValue);
                        value = theSet;
                    }
                } else {
                    if (!ConfigurationItemPropertyType.CI.equals((Object)pd.getType()) && !ConfigurationItemPropertyType.SET_OF_CIS.equals((Object)pd.getType())) throw new ConversionException("Property type " + pd.getType() + " is not supported");
                    value = null;
                }
                if (ConfigurationItemPropertyType.CI.equals((Object)pd.getType()) || ConfigurationItemPropertyType.SET_OF_CIS.equals((Object)pd.getType())) continue;
                propertyField.set(objectToPopulate, value);
            }
            return;
        }
        catch (IllegalAccessException e) {
            throw new ConversionException("Error occurred while instantiating " + objectToPopulate.getClass().getName(), e);
        }
    }

    private static Set<String> stringToSetOfStrings(String stringValue) {
        HashSet<String> theSet = new HashSet<String>();
        String strippedString = PropertyListConverter.stripOpenAndClosingBrackets(stringValue);
        StringTokenizer st = new StringTokenizer(strippedString, ",");
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            theSet.add(item.trim());
        }
        return theSet;
    }

    public static String convertObjectToString(Object detailsObject) {
        if (detailsObject instanceof Serializable) {
            ConfigurationItemDescriptor descriptor = ConfigurationItemDescriptorFactory.getDescriptor((Serializable)((Serializable)detailsObject));
            if (descriptor == null) {
                throw new RuntimeException("No Descriptor found for ConfigurationItem :" + detailsObject.getClass().getName());
            }
            return PropertyListConverter.convertObjectToString(detailsObject, descriptor.getPropertyDescriptors());
        }
        throw new RuntimeException(detailsObject.getClass() + " is not of type " + Serializable.class.getName());
    }

    private static String convertObjectToString(Object detailsObject, ConfigurationItemPropertyDescriptor[] propertyDescriptors) {
        StringBuilder result = new StringBuilder();
        for (ConfigurationItemPropertyDescriptor pd : propertyDescriptors) {
            if (ConfigurationItemPropertyType.CI.equals((Object)pd.getType()) || ConfigurationItemPropertyType.SET_OF_CIS.equals((Object)pd.getType())) continue;
            Field propertyField = pd.getPropertyField();
            try {
                Object unencodedValue;
                String key = pd.getName().toLowerCase();
                Object objectValue = pd.isPassword() && pd.getPropertyClass().isAssignableFrom(String.class) ? ((unencodedValue = propertyField.get(detailsObject)) != null ? StringCoder.encode(unencodedValue.toString()) : null) : propertyField.get(detailsObject);
                if (objectValue == null) continue;
                String value = objectValue instanceof List ? PropertyListConverter.listToString((List)objectValue, pd) : objectValue.toString();
                result.append(key).append("=").append(PropertyListConverter.encodeStringValue(value)).append(" ");
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Unable to obtain value for property " + pd.getType() + "." + pd.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to obtain value for property " + pd.getType() + "." + pd.getName(), e);
            }
        }
        return result.toString();
    }

    public static String encodeStringValue(String strValue) {
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isBlank((String)strValue) || StringUtils.containsAny((String)strValue, (String)" \\\"=")) {
            sb.append("\"");
            sb.append(StringEscapeUtils.escapeJava((String)strValue));
            sb.append("\"");
        } else {
            sb.append(strValue);
        }
        return sb.toString();
    }

    private static BeanInfo getBeanInfo(Object detailsObject) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(detailsObject.getClass());
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Unable to introspect object " + detailsObject, e);
        }
        return beanInfo;
    }

    public static List<String> getExposedProperties(Object detailsObject) {
        return PropertyListConverter.getExposedProperties(PropertyListConverter.getBeanInfo(detailsObject));
    }

    private static List<String> getExposedProperties(BeanInfo beanInfo) {
        ArrayList<String> properties = new ArrayList<String>();
        PropertyDescriptor[] javaBeanDescriptor = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < javaBeanDescriptor.length; ++i) {
            PropertyDescriptor beanDescriptor = javaBeanDescriptor[i];
            boolean isWriteAble = beanDescriptor.getWriteMethod() != null;
            String property = beanDescriptor.getName();
            if (!isWriteAble || property.equals("id") || property.equals("class") || property.equals("groupRevision") || property.equals("handle") || property.equals("revision") || property.equals("typeDescriptor") || property.equals("type")) continue;
            properties.add(beanDescriptor.getName().toLowerCase());
        }
        properties.add("label");
        properties.add("description");
        return properties;
    }

    private static String listToString(List<?> values, ConfigurationItemPropertyDescriptor propertyDescriptor) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (Object each : values) {
            sb.append("[");
            sb.append(PropertyListConverter.convertObjectToString(each, propertyDescriptor.getListObjectPropertyDescriptors()));
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    public static List stringToList(ConfigurationItemPropertyDescriptor descriptor, String value) throws ConversionException {
        ArrayList theList = new ArrayList();
        String singleMember = null;
        while ((singleMember = PropertyListConverter.readUntilClosingSquareBracket(value)) != null) {
            Object member;
            String[] subTokens;
            value = value.substring(singleMember.length(), value.length());
            if ((value = value.trim()).startsWith(",")) {
                value = value.substring(1, value.length());
                value = value.trim();
            }
            if ((subTokens = PropertyListConverter.tokenize(singleMember = PropertyListConverter.stripOpenAndClosingBrackets(singleMember))).length <= 0) continue;
            Class collectionMemberClass = descriptor.getCollectionMemberClass();
            try {
                member = collectionMemberClass.newInstance();
                Map<String, String> singleMemberAsAttributes = PropertyListConverter.tokenizeAndCreateMapFromString(singleMember);
                PropertyListConverter.populateObject(singleMemberAsAttributes, member, descriptor.getListObjectPropertyDescriptors());
            }
            catch (ConversionException e) {
                if (singleMember.indexOf(61) != -1) {
                    throw new ConversionException("Do not understand list property: \"" + singleMember + "\". Please note that spaces are not allowed in keys nor in values");
                }
                return PropertyListConverter.makeCommaSeparatedList(subTokens);
            }
            catch (InstantiationException e) {
                throw new ConversionException("Unable to instantiate " + descriptor.getCollectionMemberClassname(), e);
            }
            catch (IllegalAccessException e) {
                throw new ConversionException("Unable to instantiate " + descriptor.getCollectionMemberClassname(), e);
            }
            theList.add(member);
        }
        return theList;
    }

    private static List makeCommaSeparatedList(String[] subTokens) throws ConversionException {
        ArrayList<String> theList = new ArrayList<String>();
        for (String token : subTokens) {
            StringTokenizer st = new StringTokenizer(token, ",");
            while (st.hasMoreTokens()) {
                String item = st.nextToken();
                theList.add(item.trim());
            }
        }
        return theList;
    }

    private static String readUntilClosingSquareBracket(String inputString) {
        if (inputString == null || inputString.indexOf("[") != 0 || inputString.indexOf("]") == -1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        char currentChar = inputString.charAt(index++);
        while (currentChar != ']') {
            sb.append(currentChar);
            currentChar = inputString.charAt(index++);
        }
        sb.append(']');
        return sb.toString();
    }

    private static String stripOpenAndClosingBrackets(String singleItem) {
        singleItem = singleItem.trim();
        while (singleItem.startsWith("[")) {
            singleItem = singleItem.substring(1);
        }
        singleItem = singleItem.trim();
        if ((singleItem = singleItem.trim()).startsWith(",")) {
            singleItem = singleItem.substring(1);
            singleItem = singleItem.trim();
        }
        while (singleItem.endsWith("]")) {
            singleItem = singleItem.substring(0, singleItem.length() - 1);
        }
        singleItem = singleItem.trim();
        return singleItem;
    }

    public static Map<String, String> makeAttributes(int skipFirst, String[] tokens) throws ConversionException {
        return PropertyListConverter.makeAttributes(skipFirst, tokens, true);
    }

    public static Map<String, String> makeAttributes(int skipFirst, String[] tokens, boolean convertAttributeNamesToLowerCase) throws ConversionException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (int i = skipFirst; i < tokens.length; ++i) {
            String key = tokens[i];
            if (key.indexOf(61) != -1) {
                AttributePair kvPair = PropertyListConverter.parsePair(key);
                if (kvPair.getValue().equals("")) continue;
                attributes.put(kvPair.getKey().toLowerCase(), kvPair.getValue());
                continue;
            }
            if (++i >= tokens.length) {
                throw new ConversionException("Attributes are not of form key_1=value_1 key_2=value_2 ... key_n=value_n: " + ArrayUtils.toString((Object)tokens));
            }
            if (key.indexOf(",") != -1) {
                throw new ConversionException("Attribute key can not contain a ','. However, found this: " + key);
            }
            String value = tokens[i];
            if (value.equals(",")) {
                throw new ConversionException("Attributes are not of form key_1=value_1 key_2=value_2 ... key_n=value_n");
            }
            if (convertAttributeNamesToLowerCase) {
                key = key.toLowerCase();
            }
            attributes.put(key, value);
        }
        return attributes;
    }

    public Map<String, String> makeAttributesOld(int skipFirst, String[] tokens) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (int i = skipFirst; i < tokens.length; ++i) {
            String keyValuePair = tokens[i];
            AttributePair kvPair = PropertyListConverter.parsePair(keyValuePair);
            attributes.put(kvPair.getKey().toLowerCase(), kvPair.getValue());
        }
        return attributes;
    }

    public static String[] tokenize(String line) throws ConversionException {
        ArrayList<String> tokens = new ArrayList<String>();
        int state = 0;
        char[] chars = line.toCharArray();
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < chars.length; ++i) {
            switch (state) {
                case 0: {
                    if (chars[i] == ' ' || chars[i] == '=') {
                        state = 0;
                        continue block7;
                    }
                    if (chars[i] == '\"') {
                        state = 1;
                        continue block7;
                    }
                    if (chars[i] == '+' || chars[i] == '-') {
                        state = 4;
                        sb.append(chars[i]);
                        continue block7;
                    }
                    state = 3;
                    sb.append(chars[i]);
                    continue block7;
                }
                case 4: {
                    if (chars[i] == '=') {
                        sb.append(chars[i]);
                        state = 0;
                        tokens.add(sb.toString());
                        sb = new StringBuilder();
                        continue block7;
                    }
                    throw new ConversionException("Words starting with a '+', or '-' should be followed by a '=' to form a addMember of removeMember command. Line in error: " + line);
                }
                case 1: {
                    if (chars[i] == '\"') {
                        state = 0;
                        tokens.add(sb.toString());
                        sb = new StringBuilder();
                        continue block7;
                    }
                    if (chars[i] == '\\') {
                        state = 2;
                        continue block7;
                    }
                    sb.append(chars[i]);
                    continue block7;
                }
                case 2: {
                    sb.append(chars[i]);
                    state = 1;
                    continue block7;
                }
                case 3: {
                    boolean facingAMemberOperator = PropertyListConverter.arrivedAtMemberOperation(chars, i);
                    if (chars[i] == ' ' || chars[i] == '=' || facingAMemberOperator) {
                        if (facingAMemberOperator) {
                            state = 4;
                            tokens.add(sb.toString());
                            sb = new StringBuilder();
                            sb.append(chars[i]);
                            continue block7;
                        }
                        state = 0;
                        tokens.add(sb.toString());
                        sb = new StringBuilder();
                        continue block7;
                    }
                    if (chars[i] == '\"') {
                        throw new ConversionException("Word can not contain a '='. Line in error: " + line);
                    }
                    sb.append(chars[i]);
                }
            }
        }
        if (sb.length() > 0) {
            if (state == 1 || state == 2) {
                throw new ConversionException("Line ended before the closing quote of " + sb.toString() + ". Line in error: " + line);
            }
            tokens.add(sb.toString());
            sb = new StringBuilder();
        }
        return tokens.toArray(new String[0]);
    }

    private static boolean arrivedAtMemberOperation(char[] chars, int i) {
        return (chars[i] == '-' || chars[i] == '+') && i + 1 < chars.length && chars[i + 1] == '=';
    }

    private static AttributePair parsePair(String keyValuePair) {
        keyValuePair.trim();
        String key = keyValuePair.substring(0, keyValuePair.indexOf("="));
        String value = keyValuePair.substring(keyValuePair.indexOf("=") + 1, keyValuePair.length());
        return new AttributePair(key, value);
    }

    public static Object getValue(Object anObject, String fieldName) {
        BeanInfo beanInfo = PropertyListConverter.getBeanInfo(anObject);
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            String name = descriptor.getName();
            if (!name.equalsIgnoreCase(fieldName)) continue;
            Method readMethod = descriptor.getReadMethod();
            try {
                if (readMethod == null) continue;
                return readMethod.invoke(anObject, (Object[])null);
            }
            catch (Throwable exc) {
                throw new RuntimeException("Could not get value for " + anObject.getClass() + "." + fieldName, exc);
            }
        }
        return null;
    }

    public static Pair<List<String>, Object> getValueWithSimpleName(Object anObject, String fieldName) {
        BeanInfo beanInfo = PropertyListConverter.getBeanInfo(anObject);
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            String name = descriptor.getName();
            if (!name.equalsIgnoreCase(fieldName)) continue;
            Method readMethod = descriptor.getReadMethod();
            try {
                if (readMethod == null) continue;
                Class<?> currentClazz = anObject.getClass();
                Class<?> clazz = readMethod.getDeclaringClass();
                Object value = readMethod.invoke(anObject, (Object[])null);
                List<String> classNames = PropertyListConverter.makeClassNames(currentClazz, clazz);
                return new Pair(classNames, value);
            }
            catch (Throwable exc) {
                throw new RuntimeException("Could not get value for " + anObject.getClass() + "." + fieldName, exc);
            }
        }
        return null;
    }

    private static List<String> makeClassNames(Class<?> currentClazz, Class<?> clazz) {
        ArrayList<String> classNames = new ArrayList<String>();
        while (currentClazz != clazz) {
            classNames.add(currentClazz.getSimpleName());
            currentClazz = currentClazz.getSuperclass();
        }
        classNames.add(currentClazz.getSimpleName());
        return classNames;
    }

    private static Map<String, String> tokenizeAndCreateMapFromString(String serializedDetails) throws ConversionException {
        String[] tokens = serializedDetails != null ? PropertyListConverter.tokenize(serializedDetails) : new String[]{};
        Map<String, String> attributes = PropertyListConverter.makeAttributes(0, tokens);
        return attributes;
    }

    private static Object newObjectInstanceFromDescriptor(ConfigurationItemDescriptor descriptor) throws ConversionException {
        Object objectToPopulate;
        try {
            objectToPopulate = descriptor.getTypeClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new ConversionException("Error occurred while instantiating " + descriptor.getTypeClass().getClass().getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConversionException("Error occurred while instantiating " + descriptor.getTypeClass().getClass().getName(), e);
        }
        return objectToPopulate;
    }
}

