/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.service.impl;

import com.xebia.ad.service.UserService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.context.SecurityContext;
import org.springframework.security.context.SecurityContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringSecurityUserServiceImpl
implements UserService {
    private boolean secured;
    private boolean caseInsensitiveUsername;
    private String administratorGroup;
    public static Logger logger = Logger.getLogger(SpringSecurityUserServiceImpl.class);

    @Override
    public String getCurrentUsername() {
        if (this.isSecured()) {
            Authentication user;
            SecurityContext secCtx = SecurityContextHolder.getContext();
            if (secCtx != null && (user = secCtx.getAuthentication()) != null) {
                String username = user.getName();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("getCurrentUsername returns " + username));
                }
                return this.caseInsensitiveUsername ? username.toLowerCase() : username;
            }
            throw new SecurityException("Not logged in");
        }
        return this.caseInsensitiveUsername ? "Anonymous".toLowerCase() : "Anonymous";
    }

    @Override
    public List<String> getCurrentUserGroups() {
        ArrayList<String> userGroups = new ArrayList<String>();
        if (this.isSecured()) {
            SecurityContext secCtx = SecurityContextHolder.getContext();
            if (secCtx != null) {
                Authentication user = secCtx.getAuthentication();
                for (GrantedAuthority authority : user.getAuthorities()) {
                    userGroups.add(StringUtils.removeStart((String)authority.getAuthority(), (String)"ROLE_"));
                }
            }
        } else {
            userGroups.add(this.getAdministratorGroup());
        }
        return userGroups;
    }

    @Override
    public boolean isCurrentUserAdministrator() {
        return this.getCurrentUserGroups().contains(this.getAdministratorGroup());
    }

    @Override
    public boolean isSecured() {
        return this.secured;
    }

    @Required
    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    @Override
    public String getAdministratorGroup() {
        return this.administratorGroup;
    }

    public boolean isCaseInsensitiveUsername() {
        return this.caseInsensitiveUsername;
    }

    @Required
    public void setAdministratorGroup(String administratorGroup) {
        this.administratorGroup = administratorGroup;
    }

    @Required
    public void setCaseInsensitiveUsername(boolean caseInsensitiveUsername) {
        this.caseInsensitiveUsername = caseInsensitiveUsername;
    }
}

