/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.plugin;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ChangeResolution;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingJythonRunBook
implements RunBook {
    private final ClassLoader pluginClassLoader;
    private final String jythonScriptPath;
    private final String jythonRunBookLogCategory;
    private PyObject jythonGlobals;
    private PythonInterpreter jythonInterpreter;
    private static final PySystemState jythonSystemState = new PySystemState();
    private static final ThreadLocal<RunBookState> runBookState = new ThreadLocal();

    public DelegatingJythonRunBook(ClassLoader pluginClassLoader, String jythonScriptPath) throws IOException {
        this.pluginClassLoader = pluginClassLoader;
        this.jythonScriptPath = jythonScriptPath;
        this.jythonRunBookLogCategory = FilenameUtils.getBaseName((String)jythonScriptPath.replaceAll("/", "."));
        this.createInterpreter();
    }

    private void createInterpreter() {
        this.jythonGlobals = new PyDictionary();
        this.jythonInterpreter = new PythonInterpreter(this.jythonGlobals, jythonSystemState);
        this.jythonInterpreter.set("__filename__", (PyObject)new PyString(this.jythonScriptPath));
        this.jythonInterpreter.set("__logcategory__", (PyObject)new PyString(this.jythonRunBookLogCategory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ChangeResolution> resolve(ChangePlan changePlan) {
        this.jythonInterpreter.set("changeplan", (Object)changePlan);
        this.jythonInterpreter.set("addStep", Py.newJavaFunc(DelegatingJythonRunBook.class, (String)"addStep"));
        this.jythonInterpreter.set("markChangeHandled", Py.newJavaFunc(DelegatingJythonRunBook.class, (String)"markChangeHandled"));
        InputStream scriptIn = this.pluginClassLoader.getResourceAsStream(this.jythonScriptPath);
        try {
            RunBookState rbs = new RunBookState();
            runBookState.set(rbs);
            try {
                this.jythonInterpreter.execfile(scriptIn, this.jythonScriptPath);
            }
            finally {
                runBookState.set(null);
            }
            Collection<ChangeResolution> collection = rbs.getChangeResolutions();
            return collection;
        }
        finally {
            IOUtils.closeQuietly((InputStream)scriptIn);
        }
    }

    public static void addStep(PyObject[] args, String[] unknown) {
        RunBookState rbs = runBookState.get();
        if (rbs == null) {
            throw new RuntimeException("No run book state in thread local");
        }
        if (args == null || args.length != 1) {
            throw new RuntimeException("Expected one argument");
        }
        Step step = (Step)args[0].__tojava__(Step.class);
        rbs.addStep(step);
    }

    public static void markChangeHandled(PyObject[] args, String[] unknown) {
        RunBookState rbs = runBookState.get();
        if (rbs == null) {
            throw new RuntimeException("No run book state in thread local");
        }
        if (args == null || args.length != 1) {
            throw new RuntimeException("Expected one argument");
        }
        Change change = (Change)args[0].__tojava__(Change.class);
        rbs.markChangeHandled(change);
    }

    public static String getPythonErrorMessage(PyException pe) {
        String[] errorMessageLines = StringUtils.split((String)pe.toString(), (String)"\r\n");
        String lastErrorMessageLine = errorMessageLines[errorMessageLines.length - 1];
        return lastErrorMessageLine;
    }

    public String getJythonScriptPath() {
        return this.jythonScriptPath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RunBookState {
        private Collection<ChangeResolution> changeResolutions = new ArrayList<ChangeResolution>();
        private List<Step> steps = new ArrayList<Step>();

        private RunBookState() {
        }

        public synchronized void addStep(Step step) {
            this.steps.add(step);
        }

        public synchronized void markChangeHandled(Change<?> c) {
            ChangeResolution cr = new ChangeResolution(c);
            cr.addSteps(this.steps);
            this.changeResolutions.add(cr);
            this.steps = new ArrayList<Step>();
        }

        public Collection<ChangeResolution> getChangeResolutions() {
            return this.changeResolutions;
        }
    }
}

