/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.dao.impl;

import com.xebia.ad.dao.ChangePlanDao;
import com.xebia.ad.dao.impl.JpaBaseDaoImpl;
import com.xebia.ad.repository.metadata.ChangePlan;
import com.xebia.ad.repository.metadata.ChangePlanState;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Transactional(propagation=Propagation.MANDATORY)
public class JpaChangePlanDaoImpl
extends JpaBaseDaoImpl<ChangePlan>
implements ChangePlanDao {
    public JpaChangePlanDaoImpl() {
        super(ChangePlan.class);
    }

    @Override
    public ChangePlan findCurrentChangePlan(String username) {
        Query query = this.entityManager.createQuery("SELECT cp FROM " + this.getEntityName() + " cp WHERE cp.state != :state1 AND cp.state != :state2 AND cp.state != :state3 AND cp.username = :username");
        query.setParameter("state1", (Object)ChangePlanState.SKIPPED);
        query.setParameter("state2", (Object)ChangePlanState.CLEARED);
        query.setParameter("state3", (Object)ChangePlanState.DONE);
        query.setParameter("username", (Object)username);
        List resultList = query.getResultList();
        if (resultList.size() != 0) {
            return (ChangePlan)resultList.get(0);
        }
        return null;
    }

    @Override
    public ChangePlan getOrCreateCurrentChangePlan(String username) {
        ChangePlan result = this.findCurrentChangePlan(username);
        if (result != null) {
            return result;
        }
        result = new ChangePlan();
        result.setUsername(username);
        result.setState(ChangePlanState.EMPTY);
        this.persist(result);
        return result;
    }

    @Override
    public List<ChangePlan> findExecutingChangePlans() {
        Query query = this.entityManager.createQuery("SELECT plan FROM " + this.getEntityName() + " plan where plan.state = 'EXECUTING'");
        return query.getResultList();
    }

    @Override
    public void updateChangePlanOlderThan(Date date) {
        Query query = this.entityManager.createQuery("Select plan from " + this.getEntityName() + " plan where plan.endOfExecution < :date");
        query.setParameter("date", (Object)date);
        List changePlans = query.getResultList();
        for (ChangePlan changePlan : changePlans) {
            changePlan.removeAllSteps();
        }
    }
}

