/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.blazeds;

import flex.messaging.FlexContext;
import flex.messaging.security.LoginCommand;
import flex.messaging.security.SecurityException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.context.SecurityContext;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.context.SecurityContextImpl;
import org.springframework.security.providers.AuthenticationProvider;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringSecurityLoginCommand
implements LoginCommand {
    private final AuthenticationProvider provider;
    protected final Logger logger = Logger.getLogger(SpringSecurityLoginCommand.class);

    public SpringSecurityLoginCommand() {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)FlexContext.getServletContext());
        Map beans = wac.getBeansOfType(AuthenticationProvider.class);
        if (beans.size() > 1) {
            this.logger.warn((Object)"There are more than 1 beans of type [org.springframework.security.providers.AuthenticationProvider] in Spring context definition. The first one was picked as authentication provider.");
        }
        Map.Entry firstProviderEntry = beans.entrySet().iterator().next();
        this.provider = (AuthenticationProvider)firstProviderEntry.getValue();
        this.logger.info((Object)((String)firstProviderEntry.getKey() + " was initialized."));
    }

    public void start(ServletConfig servletConfig) {
    }

    public void stop() {
    }

    public Principal doAuthentication(String username, Object credentials) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authentication for user [" + username + "] was requested"));
        }
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)username, credentials);
        try {
            Authentication principal = this.provider.authenticate((Authentication)token);
            SecurityContext context = this.setSpringSecurityContext(principal);
            if (this.logger.isDebugEnabled()) {
                ArrayList<String> authorities = new ArrayList<String>();
                for (GrantedAuthority ga : context.getAuthentication().getAuthorities()) {
                    authorities.add(ga.getAuthority());
                }
                this.logger.debug((Object)("User [" + username + "] was authenticated with the roles [" + StringUtils.join(authorities, (String)",") + "]"));
            }
            return principal;
        }
        catch (AuthenticationException e) {
            SecurityException se = new SecurityException();
            se.setCode("Server.Authentication");
            se.setMessage(e.getMessage());
            this.logger.error((Object)(se.getCode() + ": " + se.getMessage()));
            throw se;
        }
    }

    public boolean doAuthorization(Principal principal, List roles) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authorization for [" + principal.getName() + "] was requested"));
        }
        if (!(principal instanceof Authentication)) {
            String msg = "Expected principal " + principal + " to be an instance of " + Authentication.class;
            this.logger.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        SecurityContext context = this.setSpringSecurityContext((Authentication)principal);
        boolean authorized = false;
        if (roles.contains("IS_AUTHENTICATED_FULLY")) {
            authorized = true;
        } else {
            for (GrantedAuthority ga : context.getAuthentication().getAuthorities()) {
                if (!roles.contains(ga.getAuthority())) continue;
                authorized = true;
                break;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("User [" + principal.getName() + "] was " + (authorized ? "authorized" : "NOT authorized") + " to proceed."));
        }
        return authorized;
    }

    private SecurityContext setSpringSecurityContext(Authentication principal) {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context == null) {
            context = new SecurityContextImpl();
        }
        context.setAuthentication(principal);
        return context;
    }

    public boolean logout(Principal principal) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Logout for [" + principal.getName() + "] was requested"));
        }
        SecurityContextHolder.getContext().setAuthentication(null);
        FlexContext.setUserPrincipal(null);
        return true;
    }
}

