/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad.blazeds;

import com.xebia.ad.repository.metadata.Change;
import com.xebia.ad.repository.metadata.ChangePlan;
import com.xebia.ad.repository.metadata.ConfigurationItemRevision;
import com.xebia.ad.repository.metadata.Step;
import com.xebia.ad.service.AutomatedDeploymentListener;
import com.xebia.ad.service.ConfigurationItemMetaData;
import com.xebia.ad.service.RepositoryService;
import com.xebia.ad.service.design.ui.ChangePlanView;
import com.xebia.ad.service.design.ui.StepView;
import com.xebia.ad.service.dto.DTOFactory;
import com.xebialabs.deployit.ci.security.AccessControlEntry;
import flex.messaging.MessageBroker;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import flex.messaging.util.UUIDUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BlazeDSAutomatedDeploymentListenerImpl
implements AutomatedDeploymentListener {
    private String clientId;
    private String destination;
    @Autowired
    private DTOFactory dtoFactory;
    @Autowired
    @Qualifier(value="defaultRepositoryService")
    public RepositoryService repositoryService;

    public void changePlanUpdated(ChangePlan cp) {
        ChangePlanView cpv = this.dtoFactory.createChangePlanView(cp);
        this.sendAsyncMessage(cpv, cp.getUsername());
    }

    public void stepUpdated(Step step) {
        StepView sv = this.dtoFactory.createStepView(step);
        this.sendAsyncMessage(sv, step.getChangePlan().getUsername());
    }

    public void changeCommitted(Change change) {
        ConfigurationItemRevision newRevision = change.getNewRevision();
        AccessControlEntry permissions = newRevision != null ? this.repositoryService.getPermissionsForCurrentUser(newRevision) : AccessControlEntry.getNoPermissions((String)"Anonymous");
        ConfigurationItemMetaData metaData = this.dtoFactory.createDesignConfigurationItemMetaData(newRevision, change, permissions);
        this.sendAsyncMessage(metaData, change.getChangePlan().getUsername());
    }

    protected void sendAsyncMessage(Object message, String currentUsername) {
        MessageBroker flexMessageBroker = MessageBroker.getMessageBroker(null);
        if (flexMessageBroker != null) {
            AsyncMessage msg = new AsyncMessage();
            msg.setClientId((Object)this.clientId);
            msg.setDestination(this.destination);
            msg.setMessageId(UUIDUtils.createUUID());
            msg.setTimestamp(System.currentTimeMillis());
            msg.setHeader("username", (Object)currentUsername);
            msg.setBody(message);
            flexMessageBroker.routeMessageToService((Message)msg, null);
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }
}

