/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.core.io.ClassPathResource;

public class ReleaseInfo {
    private static final String PRODUCTION_RELEASE_IDENTIFIER = "production";
    private static final String UNKNOWN_VERSION = "UNKNOWN_VERSION";
    private static final String UNKNOWN_BUILD = "UNKNOWN_BUILD";
    private static final String UNKNOWN_DATE = "UNKNOWN_DATE";
    private static final String UNKNOWN_KIND = "UNKNOWN_KIND";
    private String version;
    private String build;
    private String date;
    private String kind;
    private static ReleaseInfo instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReleaseInfo() {
        ClassPathResource releaseInfo = new ClassPathResource("com/xebia/ad/release.properties");
        try {
            InputStream in = releaseInfo.getInputStream();
            try {
                Properties p = new Properties();
                p.load(in);
                this.version = p.getProperty("version", UNKNOWN_VERSION);
                this.build = p.getProperty("build", UNKNOWN_BUILD);
                this.date = p.getProperty("timestamp", UNKNOWN_DATE);
                this.kind = p.getProperty("kind", UNKNOWN_KIND);
            }
            finally {
                in.close();
            }
        }
        catch (IOException exc) {
            this.version = UNKNOWN_VERSION;
            this.build = UNKNOWN_BUILD;
            this.date = UNKNOWN_DATE;
            this.kind = UNKNOWN_KIND;
        }
    }

    public boolean isProductionRelease() {
        return this.kind.equalsIgnoreCase(PRODUCTION_RELEASE_IDENTIFIER);
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuild() {
        return this.build;
    }

    public String getDate() {
        return this.date;
    }

    public static synchronized ReleaseInfo getReleaseInfo() {
        if (instance == null) {
            instance = new ReleaseInfo();
        }
        return instance;
    }
}

