/*
 * Decompiled with CFR 0.152.
 */
package com.xebia.ad;

import com.xebia.ad.conversion.StringCoder;
import com.xebia.ad.setup.SetupDatabaseType;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployItConfiguration {
    public static final String SPRING_CTX_CFG_LOCATION_KEY = "contextConfigLocation";
    public static final String SPRING_COMMON_SERVER_CONFIG = "classpath:spring/ad-core-context-common.xml \n classpath:spring/ad-core-context.xml";
    public static final String SPRING_UNSECURED_SERVER_CONFIG = "classpath:spring/ad-core-context-common.xml \n classpath:spring/ad-core-context.xml";
    public static final String SPRING_SECURED_LDAP_SERVER_CONFIG = "classpath:spring/ad-core-context-common.xml \n classpath:spring/ad-core-context.xml \n classpath:spring/ad-core-context-security-ldap.xml";
    public static final String SPRING_SECURED_BUILTIN_SERVER_CONFIG = "classpath:spring/ad-core-context-common.xml \n classpath:spring/ad-core-context.xml \n classpath:spring/ad-core-context-security-builtin.xml";
    public static final String SPRING_CLI_CONFIG = "classpath:/spring/ad-cli-context.xml";
    public static final String BLAZEDS_URL_PATTERN = "/messagebroker/*";
    public static final String BLAZEDS_CLASSPATH_RESOURCE_PARSER = "com.xebia.ad.blazeds.BlazeDSResourceConfigurationParser";
    public static final String BLAZEDS_UNSECURED_SERVICES_CONFIG = "blazeds/unsecured/blazeds-services-config.xml";
    public static final String BLAZEDS_SECURED_SERVICES_CONFIG = "blazeds/secured/blazeds-services-config.xml";
    public static final String HESSIAN_URL_PATTERN = "/remoting/*";
    public static final String HESSIAN_SERVLET_CONFIG = "classpath:hessian/remoting-servlet.xml";
    public static final String DEFAULT_WEBCONTENT_PACKAGE = "web";
    public static final String DEFAULT_WEB_CONTEXT_ROOT = "/";
    public static final String KEY_CI_SET = "ci.set";
    public static final String KEY_SECURED = "secured";
    public static final String KEY_USE_SSL = "ssl";
    public static final String KEY_SSL_PROTOCOL = "ssl.protocol";
    public static final String KEY_LDAP_HOST = "ldap.host";
    public static final String KEY_LDAP_PORT = "ldap.port";
    public static final String KEY_LDAP_BASE_DN = "ldap.base.dn";
    public static final String KEY_LDAP_CONNECT_DN = "ldap.connect.dn";
    public static final String KEY_LDAP_CONNECT_PASSWORD = "ldap.connect.password";
    public static final String KEY_LDAP_GROUP_SEARCH_FILTER = "ldap.search-filter.group";
    public static final String KEY_ADMINISTRATOR_GROUP = "security.group.administrator.name";
    public static final String KEY_KEYSTORE_PATH = "keystore.path";
    public static final String KEY_KEYSTORE_PASSWORD = "keystore.password";
    public static final String KEY_KEYSTORE_KEYPASSWORD = "keystore.keypassword";
    public static final String KEY_USERNAME_CASE_INSENSITIVE = "security.username.caseinsensitive";
    public static final String KEY_HTTP_PORT = "http.port";
    public static final String KEY_HIBERNATE_DIALECT = "database.dialect";
    public static final String KEY_DATABASE_DRIVERCLASS = "database.driverclass";
    public static final String KEY_DATABASE_PASSWORD = "database.password";
    public static final String KEY_DATABASE_USERNAME = "database.username";
    public static final String KEY_DATABASE_URL = "database.url";
    public static final String KEY_DATABASE_TYPE = "database.type";
    public static final String KEY_APPLICATION_REPOSITORY_PATH = "application.repository.path";
    public static final String KEY_OSB_REPOSITORY_PATH = "osb.repository.path";
    public static final String KEY_APPLICATION_TODEPLOY_PATH = "application.todeploy.path";
    public static final String KEY_MINIMUM_THREADS = "threads.min";
    public static final String KEY_MAXIMUM_THREADS = "threads.max";
    public static final String KEY_DEFAULT_PREFIX = "default.";
    public static final String KEY_CUSTOM_PREFIX = "custom.";
    public static final String KEY_APACHE_HTTP_VHOST_TEMPLATE = "apache.http.vhost.template";
    public static String CONFIGURATION_FILENAME = "deployit.conf";
    private final File configFile = new File(CONFIGURATION_FILENAME);
    protected boolean secured;
    protected String keyStorePath;
    protected String keyStorePassword;
    protected String keyStoreKeyPassword;
    protected String ciSet;
    protected int httpPort;
    protected SetupDatabaseType databaseType;
    protected String databaseDriverClass;
    protected String databaseURL;
    protected String databaseUsername;
    protected String databasePassword;
    protected String hibernateDialect;
    protected String applicationRepositoryPath;
    protected String osbRepositoryPath;
    protected String applicationToDeployPath;
    protected String ldapHost;
    protected int ldapPort;
    protected String ldapBaseDn;
    protected String ldapConnectDn;
    protected String ldapConnectPassword;
    protected String ldapGroupSearchFilter;
    protected String administratorGroupName;
    protected boolean ssl;
    protected boolean usernameCaseInsensitive;
    protected String sslProtocol;
    protected int minThreads;
    protected int maxThreads;
    protected String apacheHttpVhostTemplate;
    private Map<String, String> defaults = new HashMap<String, String>();
    private Map<String, String> customProperties = new HashMap<String, String>();
    private boolean newConfiguration = true;
    private static DeployItConfiguration instance;

    public int getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public static synchronized DeployItConfiguration getInstance() {
        if (instance == null) {
            instance = new DeployItConfiguration();
        }
        return instance;
    }

    public boolean exists() {
        return this.configFile.exists();
    }

    public void load() {
        Properties properties = new Properties();
        try {
            properties.load(FileUtils.openInputStream((File)this.configFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.secured = "true".equalsIgnoreCase(properties.getProperty(KEY_SECURED));
        this.ssl = "true".equalsIgnoreCase(properties.getProperty(KEY_USE_SSL));
        this.sslProtocol = properties.getProperty(KEY_SSL_PROTOCOL);
        this.usernameCaseInsensitive = "true".equalsIgnoreCase(properties.getProperty(KEY_USERNAME_CASE_INSENSITIVE));
        this.keyStorePath = properties.getProperty(KEY_KEYSTORE_PATH);
        this.keyStorePassword = properties.getProperty(KEY_KEYSTORE_PASSWORD);
        this.keyStoreKeyPassword = properties.getProperty(KEY_KEYSTORE_KEYPASSWORD);
        this.ciSet = properties.getProperty(KEY_CI_SET);
        this.ldapBaseDn = properties.getProperty(KEY_LDAP_BASE_DN);
        this.ldapConnectDn = properties.getProperty(KEY_LDAP_CONNECT_DN);
        this.ldapConnectPassword = properties.getProperty(KEY_LDAP_CONNECT_PASSWORD);
        this.ldapHost = properties.getProperty(KEY_LDAP_HOST);
        this.ldapGroupSearchFilter = properties.getProperty(KEY_LDAP_GROUP_SEARCH_FILTER);
        this.administratorGroupName = properties.getProperty(KEY_ADMINISTRATOR_GROUP);
        this.ldapPort = this.parseIntSilent(properties, KEY_LDAP_PORT, this.ldapPort);
        this.httpPort = this.parseIntSilent(properties, KEY_HTTP_PORT, this.httpPort);
        this.minThreads = this.parseIntSilent(properties, KEY_MINIMUM_THREADS, this.minThreads);
        this.maxThreads = this.parseIntSilent(properties, KEY_MAXIMUM_THREADS, this.maxThreads);
        this.databaseType = Enum.valueOf(SetupDatabaseType.class, properties.getProperty(KEY_DATABASE_TYPE));
        this.databaseURL = properties.getProperty(KEY_DATABASE_URL);
        this.databaseUsername = properties.getProperty(KEY_DATABASE_USERNAME);
        this.databasePassword = properties.getProperty(KEY_DATABASE_PASSWORD);
        this.databaseDriverClass = properties.getProperty(KEY_DATABASE_DRIVERCLASS);
        this.hibernateDialect = properties.getProperty(KEY_HIBERNATE_DIALECT);
        this.applicationRepositoryPath = properties.getProperty(KEY_APPLICATION_REPOSITORY_PATH);
        this.applicationToDeployPath = properties.getProperty(KEY_APPLICATION_TODEPLOY_PATH);
        this.apacheHttpVhostTemplate = properties.getProperty(KEY_APACHE_HTTP_VHOST_TEMPLATE);
        this.defaults.clear();
        this.customProperties.clear();
        for (Map.Entry<Object, Object> each : properties.entrySet()) {
            String key = (String)each.getKey();
            String value = (String)each.getValue();
            if (key.startsWith(KEY_DEFAULT_PREFIX)) {
                this.defaults.put(key.substring(KEY_DEFAULT_PREFIX.length()).toLowerCase(), value);
            }
            if (!key.startsWith(KEY_CUSTOM_PREFIX)) continue;
            this.customProperties.put(key, value);
        }
        this.newConfiguration = false;
    }

    private int parseIntSilent(Properties properties, String KEY, int defaultValue) {
        try {
            return Integer.parseInt(properties.getProperty(KEY));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public void save() {
        Properties properties = new Properties();
        properties.setProperty(KEY_SECURED, Boolean.toString(this.isSecured()));
        if (this.isSecured()) {
            properties.setProperty(KEY_LDAP_HOST, this.getLdapHost());
            properties.setProperty(KEY_LDAP_PORT, this.getLdapPort() + "");
            properties.setProperty(KEY_LDAP_BASE_DN, this.getLdapBaseDn());
            properties.setProperty(KEY_LDAP_CONNECT_PASSWORD, this.ldapConnectPassword);
            properties.setProperty(KEY_LDAP_CONNECT_DN, this.getLdapConnectDn());
        }
        properties.setProperty(KEY_USE_SSL, Boolean.toString(this.isSsl()));
        if (this.isSsl()) {
            properties.setProperty(KEY_KEYSTORE_PATH, this.getKeyStorePath());
            properties.setProperty(KEY_KEYSTORE_PASSWORD, this.keyStorePassword);
            properties.setProperty(KEY_KEYSTORE_KEYPASSWORD, this.keyStoreKeyPassword);
            if (this.getSslProtocol() != null) {
                properties.setProperty(KEY_SSL_PROTOCOL, this.getSslProtocol());
            }
        }
        properties.setProperty(KEY_ADMINISTRATOR_GROUP, this.administratorGroupName != null ? this.administratorGroupName : "");
        properties.setProperty(KEY_USERNAME_CASE_INSENSITIVE, Boolean.toString(this.usernameCaseInsensitive));
        properties.setProperty(KEY_LDAP_GROUP_SEARCH_FILTER, this.ldapGroupSearchFilter != null ? this.ldapGroupSearchFilter : "");
        properties.setProperty(KEY_HTTP_PORT, Integer.toString(this.getHttpPort()));
        properties.setProperty(KEY_DATABASE_TYPE, this.getDatabaseType().toString());
        properties.setProperty(KEY_DATABASE_URL, this.getDatabaseURL());
        properties.setProperty(KEY_DATABASE_USERNAME, this.getDatabaseUsername());
        properties.setProperty(KEY_DATABASE_PASSWORD, this.databasePassword);
        properties.setProperty(KEY_DATABASE_DRIVERCLASS, this.getDatabaseDriverClass());
        properties.setProperty(KEY_HIBERNATE_DIALECT, this.getHibernateDialect());
        properties.setProperty(KEY_APPLICATION_REPOSITORY_PATH, this.getApplicationRepositoryPath());
        properties.setProperty(KEY_APPLICATION_TODEPLOY_PATH, this.getApplicationToDeployPath());
        properties.setProperty(KEY_MINIMUM_THREADS, Integer.toString(this.minThreads));
        properties.setProperty(KEY_MAXIMUM_THREADS, Integer.toString(this.maxThreads));
        properties.setProperty(KEY_APACHE_HTTP_VHOST_TEMPLATE, this.apacheHttpVhostTemplate != null ? this.apacheHttpVhostTemplate : "");
        for (Map.Entry<String, String> each : this.defaults.entrySet()) {
            properties.put(KEY_DEFAULT_PREFIX + each.getKey(), each.getValue());
        }
        properties.putAll(this.customProperties);
        try {
            properties.store(FileUtils.openOutputStream((File)this.configFile), "Deployit configuration file.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> getJPAProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.connection.driver_class", this.getDatabaseDriverClass());
        properties.put("hibernate.connection.url", this.getDatabaseURL());
        properties.put("hibernate.connection.username", this.getDatabaseUsername());
        properties.put("hibernate.connection.password", this.getDatabasePassword());
        properties.put("hibernate.dialect", this.getHibernateDialect());
        properties.put("hibernate.archive.autodetection", "class");
        properties.put("hibernate.format_sql", "true");
        return properties;
    }

    public Map<String, String> getCreationalJPAProperties() {
        Map<String, String> properties = this.getJPAProperties();
        properties.put("hibernate.hbm2ddl.auto", "create");
        return properties;
    }

    public Properties getHibernateProperties() {
        Properties properties = new Properties();
        properties.putAll(this.getJPAProperties());
        return properties;
    }

    public Properties getCreationalHibernateProperties() {
        Properties properties = new Properties();
        properties.putAll(this.getCreationalJPAProperties());
        return properties;
    }

    public boolean isValid() {
        boolean valid = true;
        if (this.isSsl()) {
            if (StringUtils.isBlank((String)this.getKeyStorePath())) {
                System.err.println("keystore.path must be set.");
                valid = false;
            } else if (!new File(this.getKeyStorePath()).exists()) {
                System.err.println("keystore.path must point to an existing keystore.");
                valid = false;
            }
        }
        if (this.getHttpPort() < 1) {
            System.err.println("http.port is not valid, must be a number larger then 0");
            valid = false;
        }
        if (this.getDatabaseType() == null) {
            System.err.println("database.type is not valid, must be set to oracle, mysql or hsqldb.");
            valid = false;
        }
        if (StringUtils.isBlank((String)this.getDatabaseURL())) {
            System.err.println("database.url must be set.");
            valid = false;
        }
        if (StringUtils.isBlank((String)this.getDatabaseDriverClass())) {
            System.err.println("database.driverclass must be set.");
            valid = false;
        }
        if (StringUtils.isBlank((String)this.getHibernateDialect())) {
            System.err.println("database.dialect must be set.");
            valid = false;
        }
        if (StringUtils.isBlank((String)this.getApplicationRepositoryPath())) {
            System.err.println("application.repository.path must be set.");
            valid = false;
        }
        if (StringUtils.isBlank((String)this.getApplicationToDeployPath())) {
            System.err.println("application.todeploy.path must be set.");
            valid = false;
        }
        valid = this.validateThatIntIsBiggerThen(KEY_MINIMUM_THREADS, this.getMinThreads(), 0);
        valid = this.validateThatIntIsBiggerThen(KEY_MAXIMUM_THREADS, this.getMaxThreads(), this.getMinThreads());
        return valid;
    }

    private boolean validateThatIntIsBiggerThen(String KEY, int intToValidate, int shouldBeBiggerThen) {
        if (intToValidate <= shouldBeBiggerThen) {
            System.err.println(KEY + " is not valid, must be a number larger then " + shouldBeBiggerThen);
            return false;
        }
        return true;
    }

    public static DeployItConfiguration loadForUse() {
        DeployItConfiguration configuration = DeployItConfiguration.getInstance();
        if (configuration.exists()) {
            configuration.load();
            if (!configuration.isValid()) {
                throw new Error("Configuration " + CONFIGURATION_FILENAME + " is not valid please run with -setup option.");
            }
            if (!configuration.isDatabaseDriverAvailable()) {
                throw new Error((Object)((Object)configuration.getDatabaseType()) + " database driver class " + configuration.getDatabaseDriverClass() + " could not be loaded.\n" + "Please run -setup again to select the appropriate driver and check if it is available on the classpath.");
            }
        } else {
            throw new Error("Configuration " + CONFIGURATION_FILENAME + " does not exist, please run with -setup option before starting the server or command line interface.");
        }
        return configuration;
    }

    public boolean isDatabaseDriverAvailable() {
        try {
            this.getClass().getClassLoader().loadClass(this.getDatabaseDriverClass());
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        return true;
    }

    public boolean isNewConfiguration() {
        return this.newConfiguration;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public String getLdapHost() {
        return this.ldapHost;
    }

    public void setLdapHost(String ldapHost) {
        this.ldapHost = ldapHost;
    }

    public int getLdapPort() {
        return this.ldapPort;
    }

    public void setLdapPort(int ldapPort) {
        this.ldapPort = ldapPort;
    }

    public String getLdapBaseDn() {
        return this.ldapBaseDn;
    }

    public void setLdapBaseDn(String ldapBaseDn) {
        this.ldapBaseDn = ldapBaseDn;
    }

    public String getLdapConnectDn() {
        return this.ldapConnectDn;
    }

    public void setLdapConnectDn(String ldapConnectDn) {
        this.ldapConnectDn = ldapConnectDn;
    }

    public String getLdapConnectPassword() {
        return StringCoder.decode(this.ldapConnectPassword);
    }

    public void setLdapConnectPassword(String ldapConnectPassword) {
        this.ldapConnectPassword = StringCoder.encode(ldapConnectPassword);
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getKeyStorePassword() {
        return StringCoder.decode(this.keyStorePassword);
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = StringCoder.encode(keyStorePassword);
    }

    public String getKeyStoreKeyPassword() {
        return StringCoder.decode(this.keyStoreKeyPassword);
    }

    public void setKeyStoreKeyPassword(String keyStoreKeyPassword) {
        this.keyStoreKeyPassword = StringCoder.encode(keyStoreKeyPassword);
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public SetupDatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(SetupDatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public String getDatabaseDriverClass() {
        return this.databaseDriverClass;
    }

    public void setDatabaseDriverClass(String databaseDriverClass) {
        this.databaseDriverClass = databaseDriverClass;
    }

    public String getDatabaseURL() {
        return this.databaseURL;
    }

    public void setDatabaseURL(String databaseURL) {
        this.databaseURL = databaseURL;
    }

    public String getDatabaseUsername() {
        return this.databaseUsername;
    }

    public void setDatabaseUsername(String databaseUsername) {
        this.databaseUsername = databaseUsername;
    }

    public String getDatabasePassword() {
        return StringCoder.decode(this.databasePassword);
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = StringCoder.encode(databasePassword);
    }

    public String getLocation() {
        return this.configFile.getAbsolutePath();
    }

    public String getHibernateDialect() {
        return this.hibernateDialect;
    }

    public void setHibernateDialect(String hibernateDialect) {
        this.hibernateDialect = hibernateDialect;
    }

    public String getApplicationRepositoryPath() {
        return this.applicationRepositoryPath;
    }

    public void setApplicationRepositoryPath(String applicationRepositoryPath) {
        this.applicationRepositoryPath = applicationRepositoryPath;
    }

    public String getApplicationToDeployPath() {
        return this.applicationToDeployPath;
    }

    public void setApplicationToDeployPath(String applicationToDeployPath) {
        this.applicationToDeployPath = applicationToDeployPath;
    }

    public Map<String, String> getDefaults() {
        return this.defaults;
    }

    public void setDefaults(Map<String, String> defaults) {
        this.defaults = defaults;
    }

    public Map<String, String> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(Map<String, String> customProperties) {
        this.customProperties = customProperties;
    }

    public String getAdministratorGroupName() {
        return this.administratorGroupName;
    }

    public void setAdministratorGroupName(String administratorGroupName) {
        this.administratorGroupName = administratorGroupName;
    }

    public String getLdapGroupSearchFilter() {
        return this.ldapGroupSearchFilter;
    }

    public void setLdapGroupSearchFilter(String ldapGroupSearchFilter) {
        this.ldapGroupSearchFilter = ldapGroupSearchFilter;
    }

    public String getApacheHttpVhostTemplate() {
        return this.apacheHttpVhostTemplate;
    }

    public void setApacheHttpVhostTemplate(String apacheHttpVhostTemplate) {
        this.apacheHttpVhostTemplate = apacheHttpVhostTemplate;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }
}

