/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.deployment.planning;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.util.Predicates;
import java.util.Set;

public abstract class ContainerContributor<C extends Container> {
    protected final Predicate<ConfigurationItem> isTargetContainerType;
    protected Set<C> containers;

    protected ContainerContributor(Class<C> clazz) {
        this.isTargetContainerType = Predicates.instanceOf(Type.valueOf(clazz));
    }

    protected void collectContainers(Deltas deltas) {
        this.containers = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)deltas.getDeltas(), (Function)new Function<Delta, Container>(){

            public Container apply(Delta delta) {
                return this.getDeployed(delta).getContainer();
            }

            private Deployed<?, ?> getDeployed(Delta delta) {
                return delta.getOperation().equals((Object)Operation.DESTROY) ? delta.getPrevious() : delta.getDeployed();
            }
        }), this.isTargetContainerType));
    }
}

