/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.wasext.step;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.util.OverthereFileCopier;
import java.io.Closeable;

public class PluginConfigurationCopyStep
implements DeploymentStep {
    private ManagedWebServer webserver;
    private int copyStepOrder;
    private final String pluginSrcFilePath;
    private final String pluginDestFilePath;

    public PluginConfigurationCopyStep(int order, ManagedWebServer webserver) {
        this.copyStepOrder = order;
        this.webserver = webserver;
        this.pluginSrcFilePath = webserver.getNode().getCell().getWasHome() + "/config/cells/" + webserver.getNode().getCell().getCellName() + "/nodes/" + webserver.getNode().getNodeName() + "/servers/" + webserver.getName().trim() + "/plugin-cfg.xml";
        this.pluginDestFilePath = (String)webserver.getProperty("pluginConfigurationPath");
    }

    public String getDescription() {
        return String.format("Copy WebSphere plugin configuration file for unmanaged webserver " + this.webserver.getName(), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result execute(DeploymentExecutionContext ctx) throws Exception {
        OverthereConnection localConnection = this.webserver.getNode().getCell().getHost().getConnection();
        OverthereConnection remoteHostConnection = ((Host)this.webserver.getProperty("host")).getConnection();
        try {
            OverthereFile source = localConnection.getFile(this.pluginSrcFilePath);
            OverthereFile remote = remoteHostConnection.getFile(this.pluginDestFilePath);
            ctx.logOutput(String.format("Copying generated plugin configuration file from %s to %s", this.pluginSrcFilePath, this.pluginDestFilePath));
            OverthereFileCopier.copy((OverthereFile)source, (OverthereFile)remote);
        }
        finally {
            Closeables.closeQuietly((Closeable)localConnection);
            Closeables.closeQuietly((Closeable)remoteHostConnection);
        }
        return Step.Result.Success;
    }

    public int getOrder() {
        return this.copyStepOrder;
    }
}

