/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.community.wasext.task;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.Cluster;
import java.util.Map;

public class ClusterTasks {
    private static final String STOP_SCRIPT_PROPERTY = "stopScript";
    private static final String START_SCRIPT_PROPERTY = "startScript";
    private static final String STOP_ORDER_PROPERTY = "stopOrder";
    private static final String START_ORDER_PROPERTY = "startOrder";

    public static void stop(Cluster cluster, DeploymentPlanningContext ctx) {
        ClusterTasks.stop(cluster, ctx, (Integer)cluster.getProperty(STOP_ORDER_PROPERTY));
    }

    protected static void stop(Cluster cluster, DeploymentPlanningContext ctx, int order) {
        ctx.addStep((DeploymentStep)new PythonDeploymentStep(order, (PythonManagingContainer)cluster.getCell(), (String)cluster.getProperty(STOP_SCRIPT_PROPERTY), (Map)ImmutableMap.of((Object)"container", (Object)cluster), String.format("Stop cluster '%s'", cluster.getName())));
    }

    public static void start(Cluster cluster, DeploymentPlanningContext ctx) {
        ClusterTasks.start(cluster, ctx, (Integer)cluster.getProperty(START_ORDER_PROPERTY));
    }

    protected static void start(Cluster cluster, DeploymentPlanningContext ctx, int order) {
        ctx.addStep((DeploymentStep)new PythonDeploymentStep(order, (PythonManagingContainer)cluster.getCell(), (String)cluster.getProperty(START_SCRIPT_PROPERTY), (Map)ImmutableMap.of((Object)"container", (Object)cluster), String.format("Start cluster '%s'", cluster.getName())));
    }

    public static void restart(Cluster cluster, DeploymentPlanningContext ctx) {
        int startOrder = (Integer)cluster.getProperty(START_ORDER_PROPERTY);
        ClusterTasks.stop(cluster, ctx, startOrder - 2);
        ClusterTasks.start(cluster, ctx, startOrder);
    }
}

