def configureServer(container, deployed):
    # can't define these at the top level, for some reason
    def modifyServerPort(server, portName, host, port):
        def toConfigIdList(spaceSeparatedIdList):
            # input format '[id id id ...]'
            # strings.strip(chars) not available in Python 2.1
            return spaceSeparatedIdList.replace('[', '').replace(']', '').split(' ')

        node = AdminConfig.getid('/Node:%s/' % (server.nodeName))
        for serverEntry in AdminConfig.list('ServerEntry', node).splitlines():
            if server.name == AdminConfig.showAttribute(serverEntry, 'serverName'):
                for namedEndPoint in toConfigIdList(AdminConfig.showAttribute(serverEntry, 'specialEndpoints')):
                    if portName == AdminConfig.showAttribute(namedEndPoint, 'endPointName'):
                        AdminConfig.modify(AdminConfig.showAttribute(namedEndPoint, 'endPoint'), [['host', host], ['port', port]])
                        return True
        return False

    print "Configuring server '%s'" % (container.name)
    server = AdminConfig.getid('/Node:%s/Server:%s' % (container.nodeName, container.name))

    jvmConfig = AdminConfig.list("JavaVirtualMachine", server)
    javaProcessDefConfig = AdminConfig.list('JavaProcessDef', server)
    processExecutionConfig = AdminConfig.list('ProcessExecution', javaProcessDefConfig)
    outputRedirectConfig = AdminConfig.list('OutputRedirect', javaProcessDefConfig)
    outputStreamRedirectConfig = AdminConfig.showAttribute(server, 'outputStreamRedirect')
    errorStreamRedirectConfig = AdminConfig.showAttribute(server, 'errorStreamRedirect')
    applicationServerConfig = AdminConfig.list('ApplicationServer', server)
    webContainerConfig = AdminConfig.list('WebContainer', server)
    sessionManagerConfig = AdminConfig.list('SessionManager', server)
    tuningParamsConfig = AdminConfig.list('TuningParams', sessionManagerConfig)
    defaultCookieSettingsConfig = AdminConfig.list('Cookie', sessionManagerConfig)
    ejbContainerConfig = AdminConfig.list('EJBContainer', server)
    transactionServiceConfig = AdminConfig.list('TransactionService', server)
    monitoringPolicy = AdminConfig.list('MonitoringPolicy', server)

    if hasattr(deployed,'JavaVirtualMachine'):
        print 'Modifying JavaVirtualMachine parameters %s ' % (toAdminConfigArgs(deployed.JavaVirtualMachine.getExposedProperties(True)))
        AdminConfig.modify(jvmConfig,toAdminConfigArgs(deployed.JavaVirtualMachine.getExposedProperties(True)))

    if hasattr(deployed,'JavaVirtualMachineProperties'):
        print 'Setting JavaVirtualMachine properties'
        AdminConfig.modify(jvmConfig, [['systemProperties', []]])
        for key, value in deployed.JavaVirtualMachineProperties.custom.items():
            attr = [["name", key], ["value", value]]
            print "Adding JavaVirtualMachine property %s = %s" % (key,value)
            AdminConfig.create("Property", jvmConfig, attr)

    if hasattr(deployed, 'Ports'):
        print 'Modifying ports'
        for name, hostAndPort in deployed.Ports.ports.items():
            hostPort = hostAndPort.split(':')
            print "Setting port '%s' to '%s:%s'" % (name, hostPort[0], hostPort[1])
            modifyServerPort(container, name, hostPort[0], hostPort[1])

    if hasattr(deployed,'JavaProcessDef'):
        print 'Modifying JavaProcessDef parameters'
        AdminConfig.modify(javaProcessDefConfig,toAdminConfigArgs(deployed.JavaProcessDef.getExposedProperties(True)))

    if hasattr(deployed, 'JavaProcessDefEnvironmentEntries'):
        print 'Setting JavaProcessDef Environment Entries'
        AdminConfig.modify(javaProcessDefConfig, [['environment', []]])
        for key, value in deployed.JavaProcessDefEnvironmentEntries.items():
            attr = [["name", key], ["value", value]]
            print 'Adding Environment Entry %s = %s' % (key,value)
            AdminConfig.create("Property", javaProcessDefConfig, attr)
        
    if hasattr(deployed,'ProcessExecution'):
        print 'Modifying ProcessExecution parameters'
        AdminConfig.modify(processExecutionConfig, toAdminConfigArgs(deployed.ProcessExecution.getExposedProperties(True)))

    if hasattr(deployed,'OutputRedirect'):
        print 'Modifying OutputRedirect parameters'
        AdminConfig.modify(outputRedirectConfig, toAdminConfigArgs(deployed.OutputRedirect.getExposedProperties(True)))

    if hasattr(deployed,'OutputStreamRedirect'):
        print 'Modifying OutputStreamRedirect parameters'
        AdminConfig.modify(outputStreamRedirectConfig, toAdminConfigArgs(deployed.OutputStreamRedirect.getExposedProperties(True)))

    if hasattr(deployed,'ErrorStreamRedirect'):
        print 'Modifying ErrorStreamRedirect parameters'
        AdminConfig.modify(errorStreamRedirectConfig, toAdminConfigArgs(deployed.ErrorStreamRedirect.getExposedProperties(True)))

    if hasattr(deployed,'ApplicationServer'):
        print 'Modifying ApplicationServer parameters %s ' % (toAdminConfigArgs(deployed.ApplicationServer.getExposedProperties(True)))
        AdminConfig.modify(applicationServerConfig, toAdminConfigArgs(deployed.ApplicationServer.getExposedProperties(True)))

    if hasattr(deployed,'WebContainer'):
        args = toAdminConfigArgs(deployed.WebContainer.getExposedProperties(True))
        print 'Modifying WebContainer parameters %s' % (args)
        AdminConfig.modify(webContainerConfig, args)

    if hasattr(deployed,'WebContainerProperties'):
        print 'Setting WebContainer Custom Properties'
        AdminConfig.modify(webContainerConfig, [['properties', []]])
        for key, value in deployed.WebContainerProperties.custom.items():
            attr = [["name", key], ["value", value]]
            print 'Adding Custom Property %s = %s' % (key,value)
            AdminConfig.create("Property", webContainerConfig, attr)

    if hasattr(deployed,'SessionManager'):
        print 'Modifying SessionManager parameters'
        AdminConfig.modify(sessionManagerConfig, toAdminConfigArgs(deployed.SessionManager.getExposedProperties(True)))

    if hasattr(deployed,'TuningParams'):
        print 'Modifying TuningParams parameters'
        AdminConfig.modify(tuningParamsConfig, toAdminConfigArgs(deployed.TuningParams.getExposedProperties(True)))

    if hasattr(deployed, 'DefaultCookieSettings'):
        print 'Modifying DefaultCookieSetings parameters'
        AdminConfig.modify(defaultCookieSettingsConfig, toAdminConfigArgs(deployed.DefaultCookieSettings.getExposedProperties(True)))

    if hasattr(deployed,'EJBContainer'):
        args = toAdminConfigArgs(deployed.EJBContainer.getExposedProperties(True))
        print 'Modifying EJBContainer parameters %s' % (args)
        AdminConfig.modify(ejbContainerConfig, args)

    if hasattr(deployed,'TransactionService'):
        print 'Modifying TransactionService parameters'
        AdminConfig.modify(transactionServiceConfig, toAdminConfigArgs(deployed.TransactionService.getExposedProperties(True)))

    if hasattr(deployed,'MonitoringPolicy'):
        print 'Modifying MonitoringPolicy parameters'
        AdminConfig.modify(monitoringPolicy, toAdminConfigArgs(deployed.MonitoringPolicy.getExposedProperties(True)))

containerConfigType = deployed.container.wasConfigIdType
if containerConfigType == 'ServerCluster':
    for server in deployed.container.servers:
        configureServer(server, deployed)
elif containerConfigType == 'Server':
    configureServer(deployed.container, deployed)
else:
    print "Cannot modify settings on container of WebSphere config type '%s'. Nothing to do." % (containerConfigType)