cluster = AdminConfig.getid('/ServerCluster:%s/' % (container.name))
if cluster != "":
	print "WARN: Cluster '%s' already exists. Doing nothing." % (container.name)
	# trigger log display
	sys.exit(1)

args = ['-clusterConfig', ['-clusterName', container.name]]
print "Creating cluster '%s'" % (container.name)
AdminTask.createCluster(args)

for server in container.servers:
  print "Creating member server '%s' in cluster '%s'" % (server.name, container.name)
  serverArgs = ['-clusterName', container.name, '-memberConfig', ['-memberNode', server.nodeName, '-memberName', server.name, '-memberWeight', str(server.weight)]]
  AdminTask.createClusterMember(serverArgs)
  
print "Saving configuration"
AdminConfig.save()
# trigger log display
sys.exit(1)