/*
 * @(#)WasClusterSteps.java     2 Oct 2011
 *
 * Copyright © 2010 Andrew Phillips.
 *
 * ====================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
 * implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ====================================================================
 */
package com.xebialabs.deployit.community.wasext.task;

import static java.lang.String.format;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;

public class ManagedWebServerTasks {
    private static final String STOP_SCRIPT_PROPERTY = "stopScript";
    private static final String START_SCRIPT_PROPERTY = "startScript";
    private static final String STOP_ORDER_PROPERTY = "stopOrder";
    private static final String START_ORDER_PROPERTY = "startOrder";
    private static final String GENERATE_PLUGIN_SCRIPT_PROPERTY = "generatePluginScript";
    private static final String PROPAGATE_PLUGIN_SCRIPT_PROPERTY = "propagatePluginScript";
    private static final String GENERATE_PLUGIN_ORDER_PROPERTY = "generatePluginOrder";
    private static final String PROPAGATE_PLUGIN_ORDER_PROPERTY = "propagatePluginOrder";
    
    public static void stop(ManagedWebServer webserver, DeploymentPlanningContext ctx) {
        stop(webserver, ctx, webserver.<Integer>getProperty(STOP_ORDER_PROPERTY));
    }
    
    protected static void stop(ManagedWebServer webserver, DeploymentPlanningContext ctx,
            int order) {
        ctx.addStep(new PythonDeploymentStep(order, webserver.getNode().getCell(), 
                webserver.<String>getProperty(STOP_SCRIPT_PROPERTY), 
                ImmutableMap.<String, Object>of("container", webserver), 
                format("Stop web server '%s'", webserver.getName())));
    }

    public static void start(ManagedWebServer webserver, DeploymentPlanningContext ctx) {
        start(webserver, ctx, webserver.<Integer>getProperty(START_ORDER_PROPERTY));
    }
    
    protected static void start(ManagedWebServer webserver, DeploymentPlanningContext ctx,
            int order) {
        ctx.addStep(new PythonDeploymentStep(order, webserver.getNode().getCell(),
                webserver.<String>getProperty(START_SCRIPT_PROPERTY), 
                ImmutableMap.<String, Object>of("container", webserver), 
                format("Start web server '%s'", webserver.getName())));
    }
    
    // override me!
    public static void restart(ManagedWebServer webserver, DeploymentPlanningContext ctx) {
        int startOrder = webserver.<Integer>getProperty(START_ORDER_PROPERTY);
        // allow steps to be injected in between if necessary
        stop(webserver, ctx, startOrder - 2);
        start(webserver, ctx, startOrder);
    }
    
    public static void generatePlugin(ManagedWebServer webserver, DeploymentPlanningContext ctx) {
        ctx.addStep(new PythonDeploymentStep(
                webserver.<Integer>getProperty(GENERATE_PLUGIN_ORDER_PROPERTY), 
                webserver.getNode().getCell(),
                webserver.<String>getProperty(GENERATE_PLUGIN_SCRIPT_PROPERTY), 
                ImmutableMap.<String, Object>of("container", webserver),
                format("Generate web server plugin for '%s'", webserver.getName())));
    }
    
    public static void propagatePlugin(ManagedWebServer webserver, DeploymentPlanningContext ctx) {
        ctx.addStep(new PythonDeploymentStep(
                webserver.<Integer>getProperty(PROPAGATE_PLUGIN_ORDER_PROPERTY),
                webserver.getNode().getCell(),
                webserver.<String>getProperty(PROPAGATE_PLUGIN_SCRIPT_PROPERTY), 
                ImmutableMap.<String, Object>of("container", webserver),
                format("Propagate web server plugin to '%s'", webserver.getName())));        
    }
}
