/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.ProxiesInstance;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.core.api.dto.DefinedPlaceholderReference;
import com.xebialabs.deployit.core.api.dto.DefinedPlaceholderView;
import com.xebialabs.deployit.core.api.dto.DictionaryWithValueView;
import com.xebialabs.deployit.core.api.dto.ResolvedPlaceholderView;
import java.util.List;

@CliObject(name="placeholder")
@ClassHelp(description="Access to the resolved placeholders from the dictionaries.")
public class PlaceholderClient
extends DocumentedObject {
    private ProxiesInstance proxies;

    public PlaceholderClient() {
    }

    public PlaceholderClient(ProxiesInstance proxies) {
        this.proxies = proxies;
    }

    @MethodHelp(description="Lists all defined placeholders.", parameters={@ParameterHelp(name="key", description="The placeholder key.")}, returns="List or defined placeholders.")
    public List<DefinedPlaceholderView> definedPlaceholders(String key) {
        return this.proxies.getPlaceholderService().definedPlaceholders(key, null, null, null, null);
    }

    @MethodHelp(description="Lists all dictionaries with given placeholder key, value and dictionary ID.", parameters={@ParameterHelp(name="key", description="The placeholder key."), @ParameterHelp(name="value", description="The placeholder value."), @ParameterHelp(name="dictionaryId", description="The dictionary ID.")}, returns="List or defined placeholders.")
    public List<DictionaryWithValueView> definedDictionaryPlaceholders(String key, String value, String dictionaryId) {
        return this.proxies.getPlaceholderService().definedPlaceholdersByDictionary(key, value, dictionaryId, null, null, null);
    }

    @MethodHelp(description="Lists all environments with given placeholder key, value and environment ID.", parameters={@ParameterHelp(name="key", description="The placeholder key."), @ParameterHelp(name="environmentId", description="The environment ID.")}, returns="List or defined placeholders.")
    public List<DefinedPlaceholderReference> definedEnvironmentPlaceholders(String key, String environmentId) {
        return this.proxies.getPlaceholderService().definedPlaceholdersByEnvironment(key, environmentId, null, null, null);
    }

    @MethodHelp(description="Lists all resolved placeholder for specified infrastructure ci.", parameters={@ParameterHelp(name="infrastructureId", description="The id of the infrastructure.")}, returns="List or resolved placeholders.")
    public List<ResolvedPlaceholderView> infrastructure(String infrastructureId) {
        return this.proxies.getPlaceholderService().findPlaceholdersForHost(infrastructureId, null, null, null, null, null, null, null);
    }

    @MethodHelp(description="Lists all resolved placeholder for specified environment ci.", parameters={@ParameterHelp(name="environmentId", description="The id of the environment.")}, returns="List or resolved placeholders.")
    public List<ResolvedPlaceholderView> environment(String environmentId) {
        return this.proxies.getPlaceholderService().findPlaceholdersForEnvironment(environmentId, null, null, null, null, null, null, null);
    }

    @MethodHelp(description="Lists all archived resolved placeholder for specified environment ci and task id.", parameters={@ParameterHelp(name="environmentId", description="The id of the environment."), @ParameterHelp(name="taskId", description="The id of the task.")}, returns="List or archived resolved placeholders.")
    public List<ResolvedPlaceholderView> archivedForEnvironmentAndTask(String environmentId, String taskId) {
        return this.proxies.getPlaceholderService().findArchivedPlaceholdersForEnvironment(environmentId, null, null, null, null, null, taskId, null, null);
    }
}

