package com.xebialabs.deployit.cli.api.internal;

import com.xebialabs.deployit.plugin.api.reflect.*;

import static java.lang.String.format;
import static java.lang.System.out;

public class DescriptorHelper {
    public static void describe(final String typeName) {
        describeType(typeName);
    }

    private static void describeType(final String shortType) {
        final Type type = Type.valueOf(shortType);
        if (!DescriptorRegistry.exists(type)) {
            out.println();
            out.printf("No ConfigurationItem named \"%s\" found.\n", shortType);
            out.println();
            return;
        }
        Descriptor descriptor = DescriptorRegistry.getDescriptor(type);

        out.println();
        out.printf("ConfigurationItem %s:\n", descriptor.getType());
        out.printf("Description: %s\n", descriptor.getDescription());
        out.println("Control tasks:");
        for (MethodDescriptor controlTask : descriptor.getControlTasks()) {
            out.printf("\t. %s: %s\n", controlTask.getName(), controlTask.getDescription());
        }
        out.println("Properties:");
        for (PropertyDescriptor property : descriptor.getPropertyDescriptors()) {
            out.printf("\t%s %s(%s): %s\n", getPropertyModifier(property), property.getName(), getType(property), property.getDescription());
            if (property.getKind() == PropertyKind.ENUM) {
                out.printf("\t\tValues: %s\n", property.getEnumValues());
            }
        }
        out.println();
        out.println("Properties marked with a '!' are required for discovery.");
        out.println("Properties marked with a '*' are required.");
        out.println();
    }

    private static String getPropertyModifier(PropertyDescriptor property) {
        // TODO
        // if (property.isDiscoveryRequired()) {
        // return "!";
        // }
        return property.isRequired() ? "*" : "-";
    }

    private static String getType(final PropertyDescriptor property) {
        final PropertyKind type = property.getKind();
        switch (type) {
        case CI:
            return property.getReferencedType().toString();
        case SET_OF_CI:
            return format("Set<%s>", property.getReferencedType());
        case LIST_OF_CI:
            return format("List<%s>", property.getReferencedType());
        case SET_OF_STRING:
            return "Set<String>";
        case LIST_OF_STRING:
            return "List<String>";
        default:
            return type.name();
        }
    }
}
