package com.xebialabs.deployit.cli.help;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;

import com.google.common.io.ByteStreams;

import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.resteasy.DeployitClientException;
import com.xebialabs.deployit.cli.util.Closeables;

import static java.lang.String.format;

public class ExportHelp {

    private DeployitCommunicator communicator;

    public ExportHelp(DeployitCommunicator communicator) {
        this.communicator = communicator;
    }

    public long writeResourceToLocalFile(final String filePath, final String resourceURL) throws IOException {
        HttpResponse response = null;
        try {
            HttpGet httpGet = new HttpGet("/" + resourceURL);
            response = communicator.httpClient().execute(communicator.getHttpClientHolder().getHost(), httpGet);

            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                return writeFile(filePath, response);
            } else if (statusCode == 401 || statusCode == 403) {
                throw new DeployitClientException("You were not authenticated correctly, did you use the correct credentials?", statusCode);
            } else {
                String errorMessage = "An error occured: " + response.getStatusLine();
                if (response.getEntity() != null) {
                    errorMessage = EntityUtils.toString(response.getEntity());
                }
                throw new DeployitClientException(errorMessage, statusCode);
            }
        } finally {
            if (response != null) {
                EntityUtils.consume(response.getEntity());
            }
        }
    }

    private static long writeFile(String filePath, HttpResponse response) throws IOException {
        FileOutputStream outputResourceFile = null;
        try {
            outputResourceFile = new FileOutputStream(filePath);
            InputStream content = response.getEntity().getContent();
            try {
                ByteStreams.copy(content, outputResourceFile);
            } finally {
                Closeables.closeQuietly(content);
            }
            return 1;
        } catch (IOException outputFileException) {
            throw new IOException(format("The file at %s could not be created.", filePath));
        } finally {
            Closeables.closeQuietly(outputResourceFile);
        }
    }
}
