package com.xebialabs.deployit.cli.api;

import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.RemoteBooter;
import com.xebialabs.deployit.core.api.*;
import com.xebialabs.deployit.engine.api.*;

/**
 */
public class ProxiesInstance {

    private final DeployitCommunicator communicator;

    public ProxiesInstance(BooterConfig c) {
        communicator = RemoteBooter.getCommunicator(c);
        registerProxies(c.getUrl());
    }

    private void registerProxies(String url) {
        communicator.getProxies().registerProxy(url, InternalReportProxy.class);
        communicator.getProxies().registerProxy(url, InternalSecurityProxy.class);
        communicator.getProxies().registerProxy(url, InternalComparisonProxy.class);
        communicator.getProxies().registerProxy(url, PackageExportProxy.class);
        communicator.getProxies().registerProxy(url, InternalHistoryProxy.class);
    }

    private <T> T getRestEasyProxyInstance(Class<T> proxyClass) {
        return communicator.getProxies().getProxyInstance(proxyClass);
    }

    public ControlService getControlTask() {
        return getRestEasyProxyInstance(ControlService.class);
    }

    public DeploymentService getDeployment() {
        return getRestEasyProxyInstance(DeploymentService.class);
    }

    public PackageService getImportablePackage() {
        return getRestEasyProxyInstance(PackageService.class);
    }

    public RepositoryService getRepository() {
        return getRestEasyProxyInstance(RepositoryService.class);
    }

    public InspectionService getDiscovery() {
        return getRestEasyProxyInstance(InspectionService.class);
    }

    public TaskService getTaskRegistry() {
        return getRestEasyProxyInstance(TaskService.class);
    }

    public TaskBlockService getTaskBlockRegistry() {
        return getRestEasyProxyInstance(TaskBlockService.class);
    }

    public UserService getUser() {
        return getRestEasyProxyInstance(UserService.class);
    }

    public MetadataService getReferenceData() {
        return getRestEasyProxyInstance(MetadataService.class);
    }

    public ConfigurationService getConfiguration() {
        return getRestEasyProxyInstance(ConfigurationService.class);
    }

    public InternalReportProxy getReport() {
        return getRestEasyProxyInstance(InternalReportProxy.class);
    }

    public PermissionService getPermissions() {
        return getRestEasyProxyInstance(PermissionService.class);
    }

    public InternalSecurityProxy getInternalSecurity() {
        return getRestEasyProxyInstance(InternalSecurityProxy.class);
    }

    public PackageExportProxy getExportProxy() {
        return getRestEasyProxyInstance(PackageExportProxy.class);
    }

    public ServerService getServer() {
        return getRestEasyProxyInstance(ServerService.class);
    }

    public InternalComparisonProxy getComparison() {
        return getRestEasyProxyInstance(InternalComparisonProxy.class);
    }

    public RoleService getRoleService() {
        return getRestEasyProxyInstance(RoleService.class);
    }

    public InternalHistoryProxy getHistoryService() {
        return getRestEasyProxyInstance(InternalHistoryProxy.class);
    }

    public DeployitCommunicator getCommunicator() {
        return communicator;
    }
}
