/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.ObjectFactory;
import com.xebialabs.deployit.cli.api.ProxiesInstance;
import com.xebialabs.deployit.cli.api.legacy.FullTaskInfo;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.dto.SelectedDeployment;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import java.util.List;
import java.util.Map;

@CliObject(name="deployment")
@ClassHelp(description="Perform tasks related to setting up deployments")
public class DeploymentClient
extends DocumentedObject {
    private ProxiesInstance proxies;

    public DeploymentClient() {
    }

    public DeploymentClient(ProxiesInstance proxies) {
        this.proxies = proxies;
    }

    @MethodHelp(description="Check whether there is a version of the specified application deployed to the specified environment", parameters={@ParameterHelp(name="application", description="The application"), @ParameterHelp(name="environment", description="The environment")}, returns="True if any version of the application is deployed to the environment, false otherwise.")
    public boolean isDeployed(String application, String environment) {
        return this.proxies.getDeployment().isDeployed(application, environment);
    }

    @MethodHelp(description="Prepare an initial deployment of a version to an environment", parameters={@ParameterHelp(name="version", description="The source deployment package that is to be deployed"), @ParameterHelp(name="environment", description="The environment that you want to deploy to")}, returns="A deployment that can be edited further")
    public Deployment prepareInitial(String version, String environment) {
        return this.proxies.getDeployment().prepareInitial(version, environment);
    }

    @MethodHelp(description="Prepare an upgrade deployment of an existing deployed application", parameters={@ParameterHelp(name="version", description="The source deployment package that is to be deployed"), @ParameterHelp(name="deployedApplication", description="The deployed application that should be upgraded")}, returns="A deployment that can be edited further, with the deployed configuration items upgraded")
    public Deployment prepareUpgrade(String version, String deployedApplication) {
        return this.proxies.getDeployment().prepareUpdate(version, deployedApplication);
    }

    @MethodHelp(description="Generate all default deployed configuration items for deployment", parameters={@ParameterHelp(name="deployment", description="The deployment to generate all the deployed configuration items for")}, returns="The deployment updated with all the generated deployed configuration items")
    public Deployment generateAllDeployeds(Deployment deployment) {
        return this.proxies.getDeployment().generateAllDeployeds(deployment);
    }

    @MethodHelp(description="Generate default deployed configuration items for only the passed in deployables.", parameters={@ParameterHelp(name="deployables", description="The list of a deployable ids"), @ParameterHelp(name="deployment", description="The deployment to generate the deployed configuration items for")}, returns="The deployment updated with all the generated deployed configuration items")
    public Deployment generateSelectedDeployeds(List<String> deployables, Deployment deployment) {
        return this.proxies.getDeployment().generateSelectedDeployeds(new SelectedDeployment(deployables, deployment));
    }

    @MethodHelp(description="Generate default deployed configuration item for the deployable to the container", parameters={@ParameterHelp(name="deployable", description="The deployable to deploy"), @ParameterHelp(name="container", description="The container to deploy to"), @ParameterHelp(name="deployment", description="The deployment to generate the deployed configuration item for")}, returns="The deployment updated with the generated deployed configuration item")
    public Deployment generateSingleDeployed(String deployable, String container, Deployment deployment) {
        return this.proxies.getDeployment().generateSingleDeployed(deployable, container, null, deployment);
    }

    @MethodHelp(description="Generate default deployed configuration item for the deployable to the container of the specified type", parameters={@ParameterHelp(name="deployable", description="The deployable to deploy"), @ParameterHelp(name="container", description="The container to deploy to"), @ParameterHelp(name="type", description="The type of the deployed configuration item to generate"), @ParameterHelp(name="deployment", description="The deployment to generate the deployed configuration item for")}, returns="The deployment updated with the generated deployed configuration item")
    public Deployment generateSingleDeployed(String deployable, String container, String type, Deployment deployment) {
        return this.proxies.getDeployment().generateSingleDeployed(deployable, container, ObjectFactory.toType(type), deployment);
    }

    @MethodHelp(description="Generate deployed configuration items that have not yet been generated for an update deployment", parameters={@ParameterHelp(name="deployment", description="The deployment to complete")}, returns="The deployment updated with the generated deployed configuration items")
    public Deployment prepareAutoDeployeds(Deployment deployment) {
        return this.proxies.getDeployment().prepareAutoDeployeds(deployment);
    }

    @MethodHelp(description="Validate the deployment that you want to perform", parameters={@ParameterHelp(name="deployment", description="The deployment to validate")}, returns="The validated deployment with added validation messages")
    public Deployment validate(Deployment deployment) {
        return this.proxies.getDeployment().validate(deployment);
    }

    public List<StepState> taskPreview(Deployment deployment) {
        return this.proxies.getDeployment().taskPreview(deployment).getSteps();
    }

    public StepState stepPreview(Deployment deployment, int stepNr) {
        return this.proxies.getDeployment().stepPreview(deployment, stepNr);
    }

    public BlockState taskPreviewBlock(Deployment deployment) {
        return this.proxies.getDeployment().taskPreviewBlock(deployment).getBlock();
    }

    public StepState taskPreviewBlock(Deployment deployment, String blockId, int stepNr) {
        return this.proxies.getDeployment().taskPreviewBlock(deployment, blockId, stepNr);
    }

    @MethodHelp(description="!Deprecated! Prepare the deployment, readying it for execution", parameters={@ParameterHelp(name="deployment", description="The deployment to perform")}, returns="The task information needed to start the deployment", deprecated="Use deployment.createDeployTask(Deployment deployment)")
    public FullTaskInfo deploy(Deployment deployment) {
        String taskId = this.proxies.getDeployment().createTask(deployment);
        return new FullTaskInfo(this.proxies.getTaskRegistry().getSteps(taskId));
    }

    @MethodHelp(description="Prepare the deployment, readying it for execution", parameters={@ParameterHelp(name="deployment", description="The deployment to perform")}, returns="The task information needed to start the deployment")
    public TaskWithBlock createDeployTask(Deployment deployment) {
        String taskId = this.proxies.getDeployment().createTask(deployment);
        return this.proxies.getTaskBlockRegistry().getTask(taskId);
    }

    @MethodHelp(description="!Deprecated! Undeploy the deployed application", parameters={@ParameterHelp(name="deployedApplication", description="The deployed application to undeploy")}, returns="The task information needed to start the undeployment", deprecated="Use deployment.createUndeployTask(String deployedApplication)")
    public FullTaskInfo undeploy(String deployedApplication) {
        Deployment deployment = this.proxies.getDeployment().prepareUndeploy(deployedApplication);
        String taskId = this.proxies.getDeployment().createTask(deployment);
        return new FullTaskInfo(this.proxies.getTaskRegistry().getSteps(taskId));
    }

    @MethodHelp(description="Undeploy the deployed application", parameters={@ParameterHelp(name="deployedApplication", description="The deployed application to undeploy")}, returns="The task information needed to start the undeployment")
    public TaskWithBlock createUndeployTask(String deployedApplication) {
        Deployment undeployment = this.proxies.getDeployment().prepareUndeploy(deployedApplication);
        return this.createDeployTask(undeployment);
    }

    @MethodHelp(description="!Deprecated! Rollback a deployment task. The specified task will be canceled and archived and a new rollback task will be created that reverts all changes of the specified deployment task", parameters={@ParameterHelp(name="taskId", description="The id of the deployment task to rollback")}, returns="The task information needed to start the rollback task", deprecated="Use createRollbackTask(String taskId)")
    public FullTaskInfo rollbackTask(String taskId) {
        String rollbackTaskId = this.proxies.getDeployment().rollback(taskId);
        return new FullTaskInfo(this.proxies.getTaskRegistry().getSteps(rollbackTaskId));
    }

    @MethodHelp(description="Rollback a deployment task. The specified task will be canceled and archived and a new rollback task will be created that reverts all changes of the specified deployment task", parameters={@ParameterHelp(name="taskId", description="The id of the deployment task to rollback")}, returns="The task information needed to start the rollback task")
    public TaskWithBlock createRollbackTask(String taskId) {
        String rollbackTaskId = this.proxies.getDeployment().rollback(taskId);
        return this.proxies.getTaskBlockRegistry().getTask(rollbackTaskId);
    }

    @MethodHelp(description="Get the effective dictionary for an environment", parameters={@ParameterHelp(name="environmentId", description="The id of the environment"), @ParameterHelp(name="applicationId", description="The id of the application (optional)"), @ParameterHelp(name="containerId", description="The id of the container (optional)")}, returns="The effective dictionary for the environment, application and container combination")
    public Map<String, String> effectiveDictionary(String environmentId, String applicationId, String containerId) {
        return this.proxies.getDeployment().effectiveDictionary(environmentId, applicationId, containerId);
    }

    @MethodHelp(description="!Deprecated! Creates a deployment task", parameters={@ParameterHelp(name="deployedApplication", description="The application to deploy, update or undeploy.")}, returns="The task ID, needed to start the operation", deprecated="Use deployment.createDeployTask(Deployment deployment).getId()")
    public String createTask(Deployment deployment) {
        return this.proxies.getDeployment().createTask(deployment);
    }
}

