package com.xebialabs.deployit.cli.api.legacy;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import com.xebialabs.deployit.engine.api.execution.StepState;

/**
 * Translates the new {@link StepState} object to the legacy Deployit 3.7 {@code StepInfo} API.
 *
 * @ deprecated Use {@link StepState}.
 */
//@Deprecated
public class StepInfo {

    private final StepState step;
    private final int stepNr;

    public StepInfo(StepState step, int stepNr) {
        this.step = step;
        this.stepNr = stepNr;
    }

    public static List<StepInfo> asList(List<StepState> steps) {
        List<StepInfo> result = new ArrayList<StepInfo>(steps.size());
        int i = 1;
        for (StepState step : steps) {
            result.add(new StepInfo(step, i++));
        }
        return result;
    }

    public String getDescription() {
        return step.getDescription();
    }

    public String getState() {
        return step.getState().toString();
    }

    public Calendar getStartDate() {
        return step.getStartDate().toGregorianCalendar();
    }

    public Calendar getCompletionDate() {
        return step.getCompletionDate().toGregorianCalendar();
    }

    public String getLog() {
        return step.getLog();
    }

    public int getFailureCount() {
        return step.getFailureCount();
    }

    public int getNr() {
        return stepNr;
    }

    @Override
    public String toString() {
        return String.format("%2d. %s (%s)", stepNr, step.getDescription(), step.getState());
    }
}
