package com.xebialabs.deployit.cli.api;

import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.Proxies;
import com.xebialabs.deployit.core.api.InternalComparisonProxy;
import com.xebialabs.deployit.core.api.InternalReportProxy;
import com.xebialabs.deployit.core.api.InternalSecurityProxy;
import com.xebialabs.deployit.core.api.PackageExportProxy;
import com.xebialabs.deployit.engine.api.*;

import static com.xebialabs.deployit.booter.remote.Proxies.getProxyInstance;

/**
 */
public class ProxiesInstance {
    public ProxiesInstance(BooterConfig c) {
        registerProxies(c.getUrl());
    }

    private static void registerProxies(String url) {
        Proxies.registerProxy(url, DeploymentService.class);
        Proxies.registerProxy(url, PackageService.class);
        Proxies.registerProxy(url, RepositoryService.class);
        Proxies.registerProxy(url, UserService.class);
        Proxies.registerProxy(url, InspectionService.class);
        Proxies.registerProxy(url, TaskService.class);
        Proxies.registerProxy(url, InternalReportProxy.class);
        Proxies.registerProxy(url, PermissionService.class);
        Proxies.registerProxy(url, RoleService.class);
        Proxies.registerProxy(url, InternalSecurityProxy.class);
        Proxies.registerProxy(url, InternalComparisonProxy.class);
        Proxies.registerProxy(url, ControlService.class);
        Proxies.registerProxy(url, PackageExportProxy.class);
    }

    private static <T> T getRestEasyProxyInstance(Class<T> proxyClass) {
        return getProxyInstance(proxyClass);
    }

    public ControlService getControlTask() {
        return getRestEasyProxyInstance(ControlService.class);
    }

    public DeploymentService getDeployment() {
        return getRestEasyProxyInstance(DeploymentService.class);
    }

    public PackageService getImportablePackage() {
        return getRestEasyProxyInstance(PackageService.class);
    }

    public RepositoryService getRepository() {
        return getRestEasyProxyInstance(RepositoryService.class);
    }

    public InspectionService getDiscovery() {
        return getRestEasyProxyInstance(InspectionService.class);
    }

    public TaskService getTaskRegistry() {
        return getRestEasyProxyInstance(TaskService.class);
    }

    public UserService getUser() {
        return getRestEasyProxyInstance(UserService.class);
    }

    public MetadataService getReferenceData() {
        return Proxies.getMetadataService();
    }

    public InternalReportProxy getReport() {
        return getRestEasyProxyInstance(InternalReportProxy.class);
    }

    public PermissionService getPermissions() {
        return getRestEasyProxyInstance(PermissionService.class);
    }

    public InternalSecurityProxy getInternalSecurity() {
        return getRestEasyProxyInstance(InternalSecurityProxy.class);
    }

    public PackageExportProxy getExportProxy() {
        return getRestEasyProxyInstance(PackageExportProxy.class);
    }

    public ServerService getServer() {
        return Proxies.getServerService();
    }

    public InternalComparisonProxy getComparison() {
        return getRestEasyProxyInstance(InternalComparisonProxy.class);
    }

    public RoleService getRoleService() {
        return getRestEasyProxyInstance(RoleService.class);
    }

}
