/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.xebialabs.deployit.cli.Cli;
import com.xebialabs.deployit.cli.CliOptions;
import com.xebialabs.deployit.core.api.ControlTaskProxy;
import com.xebialabs.deployit.core.api.DeploymentProxy;
import com.xebialabs.deployit.core.api.DiscoveryProxy;
import com.xebialabs.deployit.core.api.ExportProxy;
import com.xebialabs.deployit.core.api.ImportablePackageProxy;
import com.xebialabs.deployit.core.api.QueryProxy;
import com.xebialabs.deployit.core.api.ReferenceDataProxy;
import com.xebialabs.deployit.core.api.ReportProxy;
import com.xebialabs.deployit.core.api.RepositoryProxy;
import com.xebialabs.deployit.core.api.SecurityProxy;
import com.xebialabs.deployit.core.api.ServerProxy;
import com.xebialabs.deployit.core.api.TaskProxy;
import com.xebialabs.deployit.core.api.UserProxy;
import java.util.HashMap;
import java.util.Map;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.executors.ApacheHttpClientExecutor;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class Proxies {
    private final Map<Class<?>, Object> registeredProxies = new HashMap();
    private final Cli.Authentication authentication;
    private final String host;

    public Proxies(CliOptions options, Cli.Authentication authentication) {
        this.authentication = authentication;
        this.host = options.getUrl();
        ResteasyDeployment resteasyDeployment = new ResteasyDeployment();
        resteasyDeployment.start();
        this.registerProxies();
    }

    private void registerProxies() {
        this.registerProxy(DeploymentProxy.class);
        this.registerProxy(ImportablePackageProxy.class);
        this.registerProxy(RepositoryProxy.class);
        this.registerProxy(QueryProxy.class);
        this.registerProxy(UserProxy.class);
        this.registerProxy(DiscoveryProxy.class);
        this.registerProxy(ReferenceDataProxy.class);
        this.registerProxy(TaskProxy.class);
        this.registerProxy(ExportProxy.class);
        this.registerProxy(ReportProxy.class);
        this.registerProxy(SecurityProxy.class);
        this.registerProxy(ServerProxy.class);
        this.registerProxy(ControlTaskProxy.class);
    }

    public String getHost() {
        return this.host;
    }

    private void registerProxy(Class<?> proxyClass) {
        ApacheHttpClientExecutor clientExecutor = new ApacheHttpClientExecutor(this.authentication.getHttpClient());
        this.registeredProxies.put(proxyClass, ProxyFactory.create(proxyClass, (String)this.host, (ClientExecutor)clientExecutor));
    }

    private <T> T getRestEasyProxyInstance(Class<T> proxyClass) {
        return (T)this.registeredProxies.get(proxyClass);
    }

    public final Cli.Authentication getAuthentication() {
        return this.authentication;
    }

    public ControlTaskProxy getControlTask() {
        return this.getRestEasyProxyInstance(ControlTaskProxy.class);
    }

    public DeploymentProxy getDeployment() {
        return this.getRestEasyProxyInstance(DeploymentProxy.class);
    }

    public ImportablePackageProxy getImportablePackage() {
        return this.getRestEasyProxyInstance(ImportablePackageProxy.class);
    }

    public RepositoryProxy getRepository() {
        return this.getRestEasyProxyInstance(RepositoryProxy.class);
    }

    public QueryProxy getQuery() {
        return this.getRestEasyProxyInstance(QueryProxy.class);
    }

    public DiscoveryProxy getDiscovery() {
        return this.getRestEasyProxyInstance(DiscoveryProxy.class);
    }

    public TaskProxy getTaskRegistry() {
        return this.getRestEasyProxyInstance(TaskProxy.class);
    }

    public ExportProxy getTaskExport() {
        return this.getRestEasyProxyInstance(ExportProxy.class);
    }

    public UserProxy getUser() {
        return this.getRestEasyProxyInstance(UserProxy.class);
    }

    public ReferenceDataProxy getReferenceData() {
        return this.getRestEasyProxyInstance(ReferenceDataProxy.class);
    }

    public ReportProxy getReport() {
        return this.getRestEasyProxyInstance(ReportProxy.class);
    }

    public SecurityProxy getSecurity() {
        return this.getRestEasyProxyInstance(SecurityProxy.class);
    }

    public ServerProxy getServer() {
        return this.getRestEasyProxyInstance(ServerProxy.class);
    }
}

