/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api.internal;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.core.api.dto.FileUpload;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportHelper {
    private static final JAXBContext JAXB_CONTEXT;
    private static final Logger logger;

    public RepositoryObject doImport(HttpClient httpClient, String baseUri, String packageToImport) {
        try {
            URL url = new URL(packageToImport);
            if (url.getProtocol().equals("file")) {
                return this.processFilePath(httpClient, baseUri, url.getFile());
            }
            PostMethod postMethod = new PostMethod(baseUri + "/importablePackages/import-url");
            postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(url.toString(), "application/xml", "UTF-8"));
            return this.executeAndExtract(httpClient, postMethod);
        }
        catch (MalformedURLException e) {
            return this.processFilePath(httpClient, baseUri, packageToImport);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private RepositoryObject executeAndExtract(HttpClient httpClient, PostMethod postMethod) {
        try {
            int i = httpClient.executeMethod((HttpMethod)postMethod);
            if (i == 201) {
                return this.extract(postMethod);
            }
            throw new RuntimeException(postMethod.getResponseBodyAsString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    protected RepositoryObject extract(PostMethod postMethod) throws JAXBException, IOException {
        return (RepositoryObject)JAXB_CONTEXT.createUnmarshaller().unmarshal(postMethod.getResponseBodyAsStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RepositoryObject processFilePath(HttpClient httpClient, String baseUri, String path) {
        File file = new File(path);
        if (file.exists()) {
            RepositoryObject repositoryObject;
            FileUpload fileUpload = new FileUpload();
            FileInputStream fileData = null;
            try {
                fileData = new FileInputStream(file);
                fileUpload.setFileData((InputStream)fileData);
                PostMethod postMethod = new PostMethod(baseUri + "/importablePackages/import-uploaded/" + file.getName());
                postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(new Part[]{new FilePart("fileData", file)}, postMethod.getParams()));
                repositoryObject = this.executeAndExtract(httpClient, postMethod);
            }
            catch (IOException e) {
                RepositoryObject repositoryObject2;
                try {
                    logger.error("The file '{}' exists, but could not be read for upload; perhaps it's not an archive.", (Object)file.toString());
                    repositoryObject2 = null;
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(fileData);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)fileData);
                return repositoryObject2;
            }
            Closeables.closeQuietly((Closeable)fileData);
            return repositoryObject;
        }
        if (!file.isAbsolute()) {
            PostMethod postMethod = new PostMethod(baseUri + "/importablePackages/import/" + path);
            return this.executeAndExtract(httpClient, postMethod);
        }
        logger.error("The file '{}' does not exist at the given absolute path", (Object)file.toString());
        return null;
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{RepositoryObject.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        logger = LoggerFactory.getLogger(ImportHelper.class);
    }
}

