/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api.internal;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.rest.ResponseExtractor;
import com.xebialabs.deployit.core.api.ReferenceDataProxy;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorList;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemMethodDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemPropertyDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemPropertyKind;
import java.util.Arrays;
import java.util.Set;

public class DescriptorHelper {
    private static volatile DescriptorHelper instance;
    private ReferenceDataProxy descriptorProxy;
    private Set<String> simpleNameMap = Sets.newHashSet();

    public DescriptorHelper(Proxies proxies) {
        this.descriptorProxy = proxies.getReferenceData();
        this.initialize();
    }

    private void initialize() {
        ConfigurationItemDescriptorList descriptors = (ConfigurationItemDescriptorList)new ResponseExtractor(this.descriptorProxy.list()).getEntity();
        this.registerSimpleNames(descriptors);
    }

    private void registerSimpleNames(ConfigurationItemDescriptorList descriptors) {
        for (ConfigurationItemDescriptorDto configurationItemDescriptorDto : descriptors.getDescriptors()) {
            this.simpleNameMap.add(configurationItemDescriptorDto.getType());
        }
    }

    public static DescriptorHelper getInstance(Proxies proxies) {
        if (instance == null) {
            instance = new DescriptorHelper(proxies);
        }
        return instance;
    }

    public String getRegisteredType(String shortCiType) {
        return this.isTypeRegistered(shortCiType) ? shortCiType : null;
    }

    public boolean isTypeRegistered(String shortCiType) {
        return this.simpleNameMap.contains(shortCiType);
    }

    public static void describe(String typeName) {
        instance.describeType(typeName);
    }

    private void describeType(String shortType) {
        String type = this.getRegisteredType(shortType);
        if (type == null) {
            System.out.println();
            System.out.printf("No ConfigurationItem named \"%s\" found.\n", shortType);
            System.out.println();
            return;
        }
        ConfigurationItemDescriptorDto ciDescriptor = (ConfigurationItemDescriptorDto)new ResponseExtractor(this.descriptorProxy.find(type)).getEntity();
        System.out.println();
        System.out.printf("ConfigurationItem %s:\n", ciDescriptor.getType());
        System.out.printf("Description: %s\n", ciDescriptor.getDescription());
        System.out.println("Control tasks:");
        for (ConfigurationItemMethodDescriptorDto controlTask : ciDescriptor.getControlTasks()) {
            System.out.printf("\t. %s: %s\n", controlTask.getName(), controlTask.getDescription());
        }
        System.out.println("Properties:");
        for (ConfigurationItemPropertyDescriptorDto property : ciDescriptor.getPropertyDescriptors()) {
            System.out.printf("\t%s %s(%s): %s\n", this.getPropertyModifier(property), property.getName(), this.getType(property), property.getDescription());
            if (property.getType() != ConfigurationItemPropertyKind.ENUM) continue;
            System.out.printf("\t\tValues: %s\n", Arrays.toString(property.getEnumValues()));
        }
        System.out.println();
        System.out.println("Properties marked with a '!' are required for discovery.");
        System.out.println("Properties marked with a '*' are required.");
        System.out.println();
    }

    private String getPropertyModifier(ConfigurationItemPropertyDescriptorDto property) {
        if (property.isDiscoveryRequired()) {
            return "!";
        }
        return property.isRequired() ? "*" : "-";
    }

    private String getType(ConfigurationItemPropertyDescriptorDto property) {
        ConfigurationItemPropertyKind type = property.getType();
        switch (type) {
            case CI: {
                return property.getPropertyClassname();
            }
            case SET_OF_CI: {
                return String.format("Set<%s>", property.getCollectionMemberClassname());
            }
            case LIST_OF_CI: {
                return String.format("List<%s>", property.getCollectionMemberClassname());
            }
            case SET_OF_STRING: {
                return "Set<String>";
            }
            case LIST_OF_STRING: {
                return "List<String>";
            }
        }
        return property.getType().name();
    }

    public Set<String> types() {
        return this.simpleNameMap;
    }
}

