/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.api.internal.DescriptorHelper;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.ExportHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.cli.rest.ResponseExtractor;
import com.xebialabs.deployit.core.api.dto.ArtifactAndData;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDtos;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemIds;
import com.xebialabs.deployit.core.api.dto.FullTaskInfos;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.resteasy.Date;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CliObject(name="repository")
@ClassHelp(description="Gateway to doing CRUD operations on all types of CIs")
public class RepositoryClient
extends DocumentedObject {
    public static final Function<ConfigurationItemId, String> ciIdToString = new Function<ConfigurationItemId, String>(){

        public String apply(ConfigurationItemId input) {
            return input.getId();
        }
    };
    private final Proxies proxies;
    private final DescriptorHelper descriptors;
    private final String parseDateFormat = "MM/dd/yyyy";
    private final String resultDateFormat = "dd MMM yyyy HH:mm z";
    private static final Logger logger = LoggerFactory.getLogger(RepositoryClient.class);

    public RepositoryClient() {
        this.proxies = null;
        this.descriptors = null;
    }

    public RepositoryClient(Proxies proxies) {
        this.proxies = proxies;
        this.descriptors = DescriptorHelper.getInstance(proxies);
    }

    @MethodHelp(description="Create a new CI in the repository", parameters={@ParameterHelp(name="ci", description="The CI (ConfigurationItem) that should be created in the repository")})
    public RepositoryObject create(ConfigurationItemDto object) {
        Preconditions.checkArgument((object.getId() != null ? 1 : 0) != 0, (Object)"The repository object should have a set id.");
        Response response = this.proxies.getRepository().create(object.getId(), object);
        return this.checkForValidations(response);
    }

    @MethodHelp(description="Create a new artifact CI in the repository", parameters={@ParameterHelp(name="artifact", description="The Artifact that should be created in the repository")})
    public RepositoryObject create(ArtifactAndData artifact) {
        Preconditions.checkArgument((artifact.getArtifact().getId() != null ? 1 : 0) != 0, (Object)"The artifact should have a set id.");
        Response response = this.proxies.getRepository().create(artifact.getArtifact().getId(), artifact);
        return this.checkForValidations(response);
    }

    @MethodHelp(description="Create all new CIs in the repository, commonly used after a discovery", parameters={@ParameterHelp(name="cis", description="The CIs (ConfigurationItems) that should be created in the repository")})
    public ConfigurationItemDtos create(ConfigurationItemDtos repositoryObjects) {
        Response response = this.proxies.getRepository().createMultiple(repositoryObjects);
        return this.checkAllForValidations(response);
    }

    @MethodHelp(description="Create all new CIs in the repository, commonly used after a discovery", parameters={@ParameterHelp(name="cis", description="The CIs (ConfigurationItems) that should be created in the repository")})
    public ConfigurationItemDtos create(List<ConfigurationItemDto> dtos) {
        Response response = this.proxies.getRepository().createMultiple(new ConfigurationItemDtos(dtos));
        return this.checkAllForValidations(response);
    }

    private ConfigurationItemDtos checkAllForValidations(Response response) {
        ResponseExtractor responseExtractor = new ResponseExtractor(response);
        ConfigurationItemDtos cis = (ConfigurationItemDtos)responseExtractor.getEntity();
        if (!responseExtractor.isValidResponse()) {
            for (ConfigurationItemDto repositoryObject : cis.getObjects()) {
                if (repositoryObject.getValidations().isEmpty()) continue;
                logger.error("Configuration item contained validation errors: {}", (Object)repositoryObject.getValidations());
            }
        }
        return cis;
    }

    @MethodHelp(description="Read a CI form the repository", parameters={@ParameterHelp(name="id", description="The id of the CI to read")})
    public RepositoryObject read(String id) {
        return (RepositoryObject)new ResponseExtractor(this.proxies.getRepository().read(id)).getEntity();
    }

    @MethodHelp(description="Update an existing CI in the repository", parameters={@ParameterHelp(name="ci", description="The updated CI (ConfigurationItem) that should be stored in the repository")})
    public RepositoryObject update(ConfigurationItemDto object) {
        Preconditions.checkArgument((object.getId() != null ? 1 : 0) != 0, (Object)"The repository object should have a set id.");
        Response response = this.proxies.getRepository().update(object.getId(), object);
        return this.checkForValidations(response);
    }

    @MethodHelp(description="Update an existing artifact in the repository", parameters={@ParameterHelp(name="artifact", description="The updated artifact CI that should be stored in the repository")})
    public RepositoryObject update(ArtifactAndData artifact) {
        Preconditions.checkArgument((artifact.getArtifact().getId() != null ? 1 : 0) != 0, (Object)"The repository object should have a set id.");
        Response response = this.proxies.getRepository().update(artifact.getArtifact().getId(), artifact);
        return this.checkForValidations(response);
    }

    @MethodHelp(description="Move a CI from one location to another", parameters={@ParameterHelp(name="ci", description="The CI that is to be moved"), @ParameterHelp(name="newId", description="The new id of the CI")}, returns="The CI with the new id")
    public RepositoryObject move(ConfigurationItemDto ci, String newId) {
        return this.move(ci.getId(), newId);
    }

    @MethodHelp(description="Move a CI from one location to another", parameters={@ParameterHelp(name="id", description="The id of the CI that is to be moved"), @ParameterHelp(name="newId", description="The new id of the CI")}, returns="The CI with the new id")
    public RepositoryObject move(String id, String newId) {
        return (RepositoryObject)new ResponseExtractor(this.proxies.getRepository().move(id, newId)).getEntity();
    }

    @MethodHelp(description="Rename a CI", parameters={@ParameterHelp(name="ci", description="The CI to rename"), @ParameterHelp(name="newName", description="The new name (last part of the id)")}, returns="The CI with the updated name")
    public RepositoryObject rename(ConfigurationItemDto ci, String newName) {
        return this.rename(ci.getId(), newName);
    }

    @MethodHelp(description="Rename a CI", parameters={@ParameterHelp(name="id", description="The id of the CI to rename"), @ParameterHelp(name="newName", description="The new name (last part of the id)")}, returns="The CI with the updated name")
    public RepositoryObject rename(String id, String newName) {
        return (RepositoryObject)new ResponseExtractor(this.proxies.getRepository().rename(id, newName)).getEntity();
    }

    @MethodHelp(description="Delete a CI with a specific id from the repository", parameters={@ParameterHelp(name="id", description="The id of the CI")})
    public void delete(String id) {
        new ResponseExtractor(this.proxies.getRepository().delete(id));
    }

    @MethodHelp(description="Search for CIs of a specific type in the repository", parameters={@ParameterHelp(name="ciType", description="")}, returns="The ids of the configuration items that fit the query.")
    public List<String> search(String ciType) {
        String type = null;
        if (ciType != null && (type = this.descriptors.getRegisteredType(ciType)) == null) {
            System.err.println("Configuration item type [null] not known.");
            return null;
        }
        ConfigurationItemIds ids = (ConfigurationItemIds)new ResponseExtractor(this.proxies.getQuery().list(type, Boolean.FALSE.booleanValue(), 0L, -1L, null, null, null)).getEntity();
        return Lists.newArrayList((Iterable)Lists.transform((List)ids.getConfigurationItemIds(), ciIdToString));
    }

    @MethodHelp(description="Search for CIs of a specific type in the repository which are located under the specified parent node.", parameters={@ParameterHelp(name="ciType", description="The type of configuration item to look for (eg. udm.DeployedApplication)"), @ParameterHelp(name="parent", description="The id of the parent node to search under (eg. Environments/env1)")}, returns="The ids of the configuration items that fit the query.")
    public List<String> search(String ciType, String parent) {
        String type = this.descriptors.getRegisteredType(ciType);
        ConfigurationItemIds ids = (ConfigurationItemIds)new ResponseExtractor(this.proxies.getQuery().list(type, Boolean.FALSE.booleanValue(), 0L, -1L, null, parent, null)).getEntity();
        return Lists.newArrayList((Iterable)Lists.transform((List)ids.getConfigurationItemIds(), ciIdToString));
    }

    @MethodHelp(description="Search for CIs of a specific type in the repository were created before the given date.", parameters={@ParameterHelp(name="ciType", description="The type of configuration item to look for (eg. udm.DeployedApplication)"), @ParameterHelp(name="before", description="a java.util.Calendar which specifies a moment in time before which the CI has to be created")}, returns="The ids of the configuration items that fit the query.")
    public List<String> search(String ciType, Calendar c) {
        ConfigurationItemIds ids = (ConfigurationItemIds)new ResponseExtractor(this.proxies.getQuery().search(ciType, new Date(c))).getEntity();
        return Lists.newArrayList((Iterable)Lists.transform((List)ids.getConfigurationItemIds(), ciIdToString));
    }

    @MethodHelp(description="Read multiple objects from the repostory in one go.", parameters={@ParameterHelp(name="ids", description="The ids of the objects to read")})
    public List<ConfigurationItemDto> read(String ... ids) {
        ConfigurationItemIds configurationItemIds = new ConfigurationItemIds();
        configurationItemIds.setConfigurationItemIds(Lists.transform(Arrays.asList(ids), (Function)new Function<String, ConfigurationItemId>(){

            public ConfigurationItemId apply(String input) {
                return new ConfigurationItemId(input, null);
            }
        }));
        ConfigurationItemDtos objs = (ConfigurationItemDtos)new ResponseExtractor(this.proxies.getQuery().readMultiple(configurationItemIds)).getEntity();
        return objs.getObjects();
    }

    @MethodHelp(description="Get all task information, including steps, from the repository's archive.", returns="This object contains all archived tasks with their enclosed steps")
    public FullTaskInfos getArchivedTasks() {
        return (FullTaskInfos)new ResponseExtractor(this.proxies.getTaskExport().getFullArchivedTasks()).getEntity();
    }

    @MethodHelp(description="Get all task information, including steps, from the repository's archive in the specified date range.", parameters={@ParameterHelp(name="beginDate", description="Begin date from which to return tasks in 'MM/dd/yyyy' format"), @ParameterHelp(name="endDate", description="End date from which to return tasks in 'MM/dd/yyyy' format")}, returns="This object contains all archived tasks with their enclosed steps")
    public FullTaskInfos getArchivedTasks(String beginDate, String endDate) {
        return (FullTaskInfos)new ResponseExtractor(this.proxies.getTaskExport().getFullArchivedTasksInDateRange(new Date(ExportHelp.parseDateFormat(beginDate, "MM/dd/yyyy", "dd MMM yyyy HH:mm z")), new Date(ExportHelp.parseDateFormat(endDate, "MM/dd/yyyy", "dd MMM yyyy HH:mm z")))).getEntity();
    }

    @MethodHelp(description="Export all task information, including steps, from the repository's archive to a local XML file", parameters={@ParameterHelp(name="filePath", description="Fully qualified pathname, including the file name, as to where to store the file to. Example: '/tmp/exportedTasks.xml'")})
    public void exportArchivedTasks(String filePath) throws IOException {
        this.getResourceToWrite(filePath, "/deployit/export/tasks");
    }

    @MethodHelp(description="Export all task information, including steps, from the repository's archive in the specified date range to a local XML file", parameters={@ParameterHelp(name="filePath", description="Fully qualified pathname, including the file name, as to where to store the file to. Example: '/tmp/exportedTasks.xml'"), @ParameterHelp(name="beginDate", description="Begin date from which to return tasks in 'MM/dd/yyyy' format"), @ParameterHelp(name="endDate", description="End date from which to return tasks in 'MM/dd/yyyy' format")})
    public void exportArchivedTasks(String filePath, String beginDate, String endDate) throws IOException {
        this.getResourceToWrite(filePath, String.format("/deployit/export/taskrange?begin=%s&end=%s", ExportHelp.encodeURIDateFormat(ExportHelp.parseDateFormat(beginDate, "MM/dd/yyyy", "dd MMM yyyy HH:mm z"), "UTF-8"), ExportHelp.encodeURIDateFormat(ExportHelp.parseDateFormat(endDate, "MM/dd/yyyy", "dd MMM yyyy HH:mm z"), "UTF-8")));
    }

    @MethodHelp(description="Check for existence of an id, does not guarantee read access to said configuration item.", parameters={@ParameterHelp(name="id", description="The id of the configuration item")}, returns="true if there is a configuration item with that id.")
    public boolean exists(String id) {
        ResponseExtractor responseExtractor = new ResponseExtractor(this.proxies.getRepository().exists(id));
        return responseExtractor.isValidResponse();
    }

    private RepositoryObject checkForValidations(Response response) {
        ResponseExtractor responseExtractor = new ResponseExtractor(response);
        RepositoryObject ci = (RepositoryObject)responseExtractor.getEntity();
        if (!responseExtractor.isValidResponse() && !ci.getValidations().isEmpty()) {
            logger.error("Configuration item contained validation errors: {}", (Object)ci.getValidations());
        }
        return ci;
    }

    private final void getResourceToWrite(String filePath, String resourcePath) throws IOException {
        if (ExportHelp.writeResourceToLocalFile(this.proxies.getAuthentication(), filePath, resourcePath) > 0L) {
            System.out.println(String.format("Written archived tasks to %s", filePath));
        } else {
            System.out.println("File was created but no bytes were written to the file.\n");
            System.out.println("Maybe the requested resource was not available or zero size!?");
        }
    }
}

