/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api.internal;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.rest.ResponseExtractor;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemPropertyDescriptorDto;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PrintHelper {
    private final Set<String> repositoryObjectParentIds = Sets.newHashSet();

    private PrintHelper() {
    }

    public static final PrintHelper getInstance() {
        return new PrintHelper();
    }

    public void printCi(RepositoryObject repositoryObject, Proxies proxies) {
        this.printTopLevelCiWithIndent(repositoryObject, "", proxies);
    }

    public void printCis(Collection<RepositoryObject> collection, Proxies proxies) {
        this.repositoryObjectParentIds.addAll(Collections2.transform(collection, (Function)new Function<RepositoryObject, String>(){

            public String apply(RepositoryObject repositoryObject) {
                return repositoryObject.getId();
            }
        }));
        for (RepositoryObject repositoryObject : collection) {
            this.printTopLevelCiWithIndent(repositoryObject, "", proxies);
        }
    }

    private void printTopLevelCiWithIndent(RepositoryObject repositoryObject, String string, Proxies proxies) {
        System.out.println(repositoryObject.getType());
        this.printCiProperties(repositoryObject, string, proxies);
    }

    private void printCiProperties(RepositoryObject repositoryObject, String string, Proxies proxies) {
        this.repositoryObjectParentIds.add(repositoryObject.getId());
        this.println(string, "id", repositoryObject.getId(), false);
        this.printCalendar(string, "lastModified", repositoryObject.getLastModified(), false);
        this.println(string, "values", null, true);
        Map<String, ConfigurationItemPropertyDescriptorDto> map = this.getPropertyDescriptors(repositoryObject, proxies);
        this.printValues(repositoryObject, string + "    ", proxies, map);
    }

    private void printValues(RepositoryObject repositoryObject, String string, Proxies proxies, Map<String, ConfigurationItemPropertyDescriptorDto> map) {
        Set set = repositoryObject.getValues().entrySet();
        Iterator iterator = set.iterator();
        block7: while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ConfigurationItemPropertyDescriptorDto configurationItemPropertyDescriptorDto = map.get(entry.getKey());
            boolean bl = !iterator.hasNext();
            String string2 = string + (iterator.hasNext() ? "|   " : "    ");
            if (configurationItemPropertyDescriptorDto == null) {
                this.println(string, "(INVALID) " + (String)entry.getKey(), entry.getValue().toString(), bl);
                continue;
            }
            switch (configurationItemPropertyDescriptorDto.getType()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    this.println(string, (String)entry.getKey(), entry.getValue().toString(), bl);
                    break;
                }
                case SET_OF_STRING: 
                case LIST_OF_STRING: {
                    Object object;
                    this.println(string, (String)entry.getKey(), null, bl);
                    Collection collection = (Collection)entry.getValue();
                    Object object2 = collection.iterator();
                    while (object2.hasNext()) {
                        object = (String)object2.next();
                        this.println(string2, (String)object, null, !object2.hasNext());
                    }
                    continue block7;
                }
                case MAP_STRING_STRING: {
                    this.println(string, (String)entry.getKey(), null, bl);
                    Object object2 = (Map)entry.getValue();
                    for (Map.Entry entry2 : object2.entrySet()) {
                        this.println(string2, (String)entry2.getKey(), (String)entry2.getValue(), !iterator.hasNext());
                    }
                    continue block7;
                }
                case CI: {
                    Object object = (String)entry.getValue();
                    if (!this.repositoryObjectParentIds.contains(object)) {
                        RepositoryObject repositoryObject2 = (RepositoryObject)new ResponseExtractor(proxies.getRepository().read((String)object)).getEntity();
                        this.println(string, (String)entry.getKey(), repositoryObject2.getType(), bl);
                        this.printCiProperties(repositoryObject2, string2, proxies);
                        break;
                    }
                    this.println(string, (String)entry.getKey(), "REFERENCE => " + (String)object, bl);
                    break;
                }
                case SET_OF_CI: 
                case LIST_OF_CI: {
                    this.println(string, (String)entry.getKey(), null, bl);
                    Collection collection = (Collection)entry.getValue();
                    this.printSetOfCis(string2, collection, proxies);
                    break;
                }
            }
        }
    }

    private void printSetOfCis(String string, Collection<String> collection, Proxies proxies) {
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (!this.repositoryObjectParentIds.contains(string2)) {
                RepositoryObject repositoryObject = (RepositoryObject)new ResponseExtractor(proxies.getRepository().read(string2)).getEntity();
                this.println(string, repositoryObject.getType(), null, !iterator.hasNext());
                this.printCiProperties(repositoryObject, string + (iterator.hasNext() ? "|   " : "    "), proxies);
                continue;
            }
            this.println(string, "REFERENCE => " + string2, null, !iterator.hasNext());
        }
    }

    private Map<String, ConfigurationItemPropertyDescriptorDto> getPropertyDescriptors(RepositoryObject repositoryObject, Proxies proxies) {
        ConfigurationItemDescriptorDto configurationItemDescriptorDto = (ConfigurationItemDescriptorDto)new ResponseExtractor(proxies.getReferenceData().find(repositoryObject.getType())).getEntity();
        List list = configurationItemDescriptorDto.getPropertyDescriptors();
        HashMap hashMap = Maps.newHashMap();
        for (ConfigurationItemPropertyDescriptorDto configurationItemPropertyDescriptorDto : list) {
            hashMap.put(configurationItemPropertyDescriptorDto.getName(), configurationItemPropertyDescriptorDto);
        }
        return hashMap;
    }

    private void println(String string, String string2, String string3, boolean bl) {
        System.out.println(string + (bl ? "\\-- " : "+-- ") + string2 + (string3 != null ? ": " + string3 : ""));
    }

    private void printCalendar(String string, String string2, Calendar calendar, boolean bl) {
        if (calendar != null) {
            this.println(string, string2, new SimpleDateFormat("yyyy-MM-dd hh:MM:ss.SSS").format(calendar.getTime()), bl);
        } else {
            this.println(string, string2, null, bl);
        }
    }
}

