/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.cli.Cli;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.cli.rest.ResponseExtractor;
import com.xebialabs.deployit.core.api.ReferenceDataProxy;
import com.xebialabs.deployit.core.api.SecurityProxy;
import com.xebialabs.deployit.core.api.ServerProxy;
import com.xebialabs.deployit.core.api.UserProxy;
import com.xebialabs.deployit.core.api.dto.Permission;
import com.xebialabs.deployit.core.api.dto.Permissions;
import com.xebialabs.deployit.core.api.dto.PrincipalPermissions;
import com.xebialabs.deployit.core.api.dto.Role;
import com.xebialabs.deployit.core.api.dto.RoleAssignment;
import com.xebialabs.deployit.core.api.dto.RoleAssignments;
import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.core.api.dto.Roles;
import com.xebialabs.deployit.core.api.dto.User;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CliObject(name="security")
@ClassHelp(description="Access to the security settings of Deployit.")
public class SecurityClient
extends DocumentedObject {
    private final UserProxy userProxy;
    private final SecurityProxy securityProxy;
    private final ServerProxy serverProxy;
    private final ReferenceDataProxy referenceDataProxy;
    private static final Logger logger = LoggerFactory.getLogger(SecurityClient.class);

    public SecurityClient() {
        this.userProxy = null;
        this.securityProxy = null;
        this.serverProxy = null;
        this.referenceDataProxy = null;
    }

    public SecurityClient(Proxies proxies) {
        this.userProxy = proxies.getUser();
        this.securityProxy = proxies.getSecurity();
        this.serverProxy = proxies.getServer();
        this.referenceDataProxy = proxies.getReferenceData();
    }

    @MethodHelp(description="Logout the currently logged in user, can only perform further actions after a login")
    public void logout() {
        this.securityProxy.logout();
        Cli.getAuthentication().logout();
    }

    @MethodHelp(description="Login a user", parameters={@ParameterHelp(name="username", description="The username"), @ParameterHelp(name="password", description="The password")})
    public void login(String string, String string2) {
        logger.info("Logging in as {}", (Object)string);
        Cli.getAuthentication().loginAs(string, string2);
        Response response = this.serverProxy.getInfo();
        if (response.getStatus() > 200) {
            Cli.getAuthentication().logout();
            throw new IllegalStateException("You're not authorized with these credentials. (" + string + ")");
        }
    }

    @MethodHelp(description="Create a user with the specified name and password", parameters={@ParameterHelp(name="username", description="The username"), @ParameterHelp(name="password", description="The password")}, returns="The created user")
    public User createUser(String string, String string2) {
        return this.createUser(string, string2, false);
    }

    public User createUser(String string, String string2, boolean bl) {
        User user = new User(string, bl);
        user.setPassword(string2);
        return (User)new ResponseExtractor(this.userProxy.create(string, user)).getEntity();
    }

    @MethodHelp(description="Read a user so that he/she can be modified.", parameters={@ParameterHelp(name="username", description="The username of the user to read")}, returns="The read user")
    public User readUser(String string) {
        return (User)new ResponseExtractor(this.userProxy.read(string)).getEntity();
    }

    @MethodHelp(description="Modify the (password of) the user.", parameters={@ParameterHelp(name="user", description="The updated user object.")})
    public void modifyUser(User user) {
        new ResponseExtractor(this.userProxy.modifyPassword(user.getUsername(), user));
    }

    @MethodHelp(description="Delete a user.", parameters={@ParameterHelp(name="username", description="the username of the user to be deleted")})
    public void deleteUser(String string) {
        new ResponseExtractor(this.userProxy.delete(string));
    }

    @MethodHelp(description="Grant a permission to a role", parameters={@ParameterHelp(name="permission", description="The permission to grant"), @ParameterHelp(name="roleName", description="The role")})
    public void grant(String string, String string2) {
        this.doGrant(string, string2, "global");
    }

    @MethodHelp(description="Grant a permission to a role on a group of configuration items", parameters={@ParameterHelp(name="permission", description="The permission to grant"), @ParameterHelp(name="roleName", description="The role"), @ParameterHelp(name="configurationItems", description="A list of configuration items to which the permission should apply")})
    public void grant(String string, String string2, List<String> list) {
        List<String> list2 = this.removeTrailingSlashes(list);
        for (String string3 : list2) {
            this.doGrant(string, string2, string3);
        }
    }

    @MethodHelp(description="Revoke a permission from a role", parameters={@ParameterHelp(name="permission", description="The permission to revoke"), @ParameterHelp(name="roleName", description="The role")})
    public void revoke(String string, String string2) {
        this.doRevoke(string, string2, "global");
    }

    @MethodHelp(description="Revoke a permission from a role on a group of configuration items", parameters={@ParameterHelp(name="permission", description="The permission to grant"), @ParameterHelp(name="roleName", description="The role"), @ParameterHelp(name="configurationItems", description="A list of configuration items from which the permission should be removed")})
    public void revoke(String string, String string2, List<String> list) {
        List<String> list2 = this.removeTrailingSlashes(list);
        for (String string3 : list2) {
            this.doRevoke(string, string2, string3);
        }
    }

    private void doGrant(String string, String string2, String string3) {
        RolePermissions rolePermissions = (RolePermissions)new ResponseExtractor(this.securityProxy.getGrantedPermissions(string3)).getEntity();
        rolePermissions.get(string2).grant(string);
        new ResponseExtractor(this.securityProxy.writeGrantedPermissions(string3, rolePermissions));
    }

    private void doRevoke(String string, String string2, String string3) {
        RolePermissions rolePermissions = (RolePermissions)new ResponseExtractor(this.securityProxy.getGrantedPermissions(string3)).getEntity();
        rolePermissions.get(string2).revoke(string);
        new ResponseExtractor(this.securityProxy.writeGrantedPermissions(string3, rolePermissions));
    }

    @MethodHelp(description="Check whether a permission is granted to the logged in user on an id.", parameters={@ParameterHelp(name="permission", description="The permission to check"), @ParameterHelp(name="principal", description="The user or group whose permissions are to be retrieved")}, returns="A permissions object containing the user's or group's granted permissions")
    public boolean hasPermission(String string, String string2) {
        try {
            new ResponseExtractor(this.securityProxy.hasPermission(string, string2));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @MethodHelp(description="Get permissions granted to a user or group", parameters={@ParameterHelp(name="principal", description="The user or group whose permissions are to be retrieved")}, returns="A permissions object containing the user's or group's granted permissions")
    public PrincipalPermissions getPermissions(String string) {
        return (PrincipalPermissions)new ResponseExtractor(this.securityProxy.retrievePermissions(string)).getEntity();
    }

    @MethodHelp(description="Get permissions granted to the currently logged in user")
    public PrincipalPermissions getPermissions() {
        return this.getPermissions(Cli.getAuthentication().getUserName());
    }

    @MethodHelp(description="List all the permissions available in Deployit")
    public void printPermissions() {
        Permissions permissions = (Permissions)new ResponseExtractor(this.referenceDataProxy.permissionList()).getEntity();
        System.out.println("Available permissions are:");
        for (Permission permission : permissions.getPermissions()) {
            System.out.println(permission.getPermissionName());
        }
    }

    @MethodHelp(description="Create or update a role with assigned principals.", parameters={@ParameterHelp(name="roleName", description="The role name"), @ParameterHelp(name="principals", description="The assigned principals")})
    public void assignRole(String string, List<String> list) {
        RoleAssignments roleAssignments = (RoleAssignments)new ResponseExtractor(this.securityProxy.getRoleAssignments()).getEntity();
        roleAssignments.assignRole(string, list);
        new ResponseExtractor(this.securityProxy.writeRoleAssignments(roleAssignments));
    }

    @MethodHelp(description="Remove a role.", parameters={@ParameterHelp(name="roleName", description="The role name")})
    public void removeRole(String string) {
        RoleAssignments roleAssignments = (RoleAssignments)new ResponseExtractor(this.securityProxy.getRoleAssignments()).getEntity();
        roleAssignments.removeRole(string);
        new ResponseExtractor(this.securityProxy.writeRoleAssignments(roleAssignments));
    }

    @MethodHelp(description="Get all existing roles in Deployit.", returns="The list of role names")
    public List<String> getRoleNames() {
        Roles roles = (Roles)new ResponseExtractor(this.securityProxy.getRoles()).getEntity();
        return Lists.newArrayList((Iterable)Lists.transform((List)roles.getRoles(), (Function)new Function<Role, String>(){

            public String apply(Role role) {
                return role.getName();
            }
        }));
    }

    public void renameRole(String string, String string2) {
        RoleAssignments roleAssignments = (RoleAssignments)new ResponseExtractor(this.securityProxy.getRoleAssignments()).getEntity();
        for (RoleAssignment roleAssignment : roleAssignments.getAssignments()) {
            if (!roleAssignment.getRole().getName().equals(string)) continue;
            roleAssignment.getRole().setName(string2);
            break;
        }
        new ResponseExtractor(this.securityProxy.writeRoleAssignments(roleAssignments));
    }

    @MethodHelp(description="Get the principals assigned to a specific role.", parameters={@ParameterHelp(name="roleName", description="The role name")}, returns="A list of principals assigned to the role")
    public List<String> getRoleAssignments(String string) {
        RoleAssignments roleAssignments = (RoleAssignments)new ResponseExtractor(this.securityProxy.getRoleAssignments()).getEntity();
        List list = roleAssignments.getAssignments();
        for (RoleAssignment roleAssignment : list) {
            if (!roleAssignment.getRole().getName().equals(string)) continue;
            return roleAssignment.getPrincipals();
        }
        return Lists.newArrayList();
    }

    private List<String> removeTrailingSlashes(List<String> list) {
        ArrayList arrayList = Lists.newArrayList();
        for (String string : list) {
            arrayList.add(string.replaceFirst("/*$", ""));
        }
        return arrayList;
    }
}

