/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.api.internal.DescriptorHelper;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.core.api.dto.ArtifactAndData;
import com.xebialabs.deployit.core.api.dto.ArtifactDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDto;
import java.util.Map;
import java.util.TreeSet;

@CliObject(name="factory")
@ClassHelp(description="Helper that can construct Configuration Items (CI) and Artifacts")
public class ObjectFactory
extends DocumentedObject {
    private DescriptorHelper descriptors;

    public ObjectFactory() {
    }

    public ObjectFactory(Proxies proxies) {
        this.descriptors = DescriptorHelper.getInstance(proxies);
    }

    @MethodHelp(description="Construct a CI of a specified type", parameters={@ParameterHelp(name="id", description="The id of the CI"), @ParameterHelp(name="ciType", description="The type of the CI")})
    public ConfigurationItemDto configurationItem(String string, String string2) {
        return this.ci(string, string2, Maps.newHashMap());
    }

    @MethodHelp(description="Construct a CI of a specified type with specified values", parameters={@ParameterHelp(name="id", description="The id of the CI"), @ParameterHelp(name="ciType", description="The type of the CI"), @ParameterHelp(name="values", description="The values of the CI in a map.")})
    public ConfigurationItemDto configurationItem(String string, String string2, Map<String, Object> map) {
        return this.ci(string, string2, map);
    }

    private ConfigurationItemDto ci(String string, String string2, Map<String, Object> map) {
        Preconditions.checkArgument((boolean)this.isValidType(string2), (String)"Unknown CI type %s", (Object[])new Object[]{string2});
        String string3 = this.descriptors.getRegisteredType(string2);
        ConfigurationItemDto configurationItemDto = new ConfigurationItemDto(string3);
        configurationItemDto.setId(string);
        configurationItemDto.setValues((Map)Maps.newHashMap(map));
        return configurationItemDto;
    }

    @MethodHelp(description="Construct an artifact of a specific type with associated data", parameters={@ParameterHelp(name="id", description="The id of the artifact"), @ParameterHelp(name="ciType", description="The type of the artifact"), @ParameterHelp(name="values", description="The values for the artifact in a map."), @ParameterHelp(name="data", description="The data of the artifact that is to be uploaded")}, returns="An Artifact with data that can be stored in Deployit.")
    public ArtifactAndData artifact(String string, String string2, Map<String, Object> map, byte[] byArray) {
        Preconditions.checkArgument((boolean)this.isValidType(string2), (String)"Unknown CI type %s", (Object[])new Object[]{string2});
        String string3 = this.descriptors.getRegisteredType(string2);
        ArtifactDto artifactDto = new ArtifactDto(string3);
        artifactDto.setId(string);
        artifactDto.setValues((Map)Maps.newHashMap(map));
        return new ArtifactAndData(artifactDto, byArray);
    }

    @MethodHelp(description="Prints all registered configuration item types.")
    public void types() {
        TreeSet treeSet = Sets.newTreeSet(this.descriptors.types());
        System.out.printf("The registered configuration item types are:\n%s\n\n", treeSet);
    }

    private boolean isValidType(String string) {
        return this.descriptors.isTypeRegistered(string);
    }
}

