/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StopOptionHandler;

public class CliOptions {
    static final int DEFAULT_DEPLOYIT_SERVER_PORT = 4516;
    static final int DEFAULT_DEPLOYIT_SERVER_SECURE_PORT = 4517;
    static final String DEFAULT_DEPLOYIT_SERVER_HOST = "127.0.0.1";
    static final String EXTENSION_DIR = "ext";
    @Option(name="-secure", usage="Use https to connect to the Deployit server", required=false)
    private boolean secured = false;
    @Option(name="-expose-proxies", required=false)
    private boolean exposeProxies = false;
    @Option(name="-host", usage="Connect to a specified host, defaults to 127.0.0.1", required=false)
    private String host = "127.0.0.1";
    @Option(name="-port", usage="Connect to a specified port, defaults to 4516", required=false)
    private int port = -1;
    @Option(name="-context", usage="Context url Deployit is running at, defaults to ''", required=false)
    private String context = "";
    @Option(name="-f", usage="Execute a specified python source file", required=false, aliases={"-source"})
    private String sourceFileName = null;
    @Option(name="-q", aliases={"-quiet"}, usage="Suppresses the welcome banner", required=false)
    private boolean quiet = false;
    @Option(name="-username", usage="Connect as the specified user", required=false)
    private String username;
    @Option(name="-password", usage="Connect with the specified password", required=false)
    private String password;
    @Option(name="-configuration", usage="Specify the location of the configuration file", required=false)
    private String configLocation = "conf";
    @Option(name="-help", usage="Prints this usage message", required=false)
    private boolean printUsage = false;
    @Argument
    @Option(name="--", handler=StopOptionHandler.class)
    private List<String> scriptArgs = Lists.newArrayList();
    private static final String DEPLOYIT_CONF_FILE_NAME = "deployit.conf";

    public void setHost(String string) {
        this.host = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getPort() {
        return this.port == -1 ? (this.secured ? 4517 : 4516) : this.port;
    }

    public void setSourceFileName(String string) {
        this.sourceFileName = string;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public boolean interpretSourceFile() {
        return this.sourceFileName != null;
    }

    public boolean isUsernameOnCommandline() {
        return this.username != null;
    }

    public boolean isPasswordOnCommandline() {
        return this.password != null;
    }

    public boolean isExposeProxies() {
        return this.exposeProxies;
    }

    public void setExposeProxies(boolean bl) {
        this.exposeProxies = bl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String string) {
        this.configLocation = string;
    }

    public File getConfigurationFile() {
        return new File(this.configLocation, DEPLOYIT_CONF_FILE_NAME);
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setSecured(boolean bl) {
        this.secured = bl;
    }

    public String getUrl() {
        return String.format("http%s://%s:%d/%s", this.secured ? "s" : "", this.host, this.getPort(), this.getContext());
    }

    public List<String> getScriptArgs() {
        return this.scriptArgs;
    }

    public void setScriptArgs(List<String> list) {
        this.scriptArgs = list;
    }

    public String getContext() {
        if (!this.context.endsWith("deployit")) {
            this.context = this.context + "/deployit";
        }
        if (this.context.startsWith("/")) {
            this.context = this.context.substring(1);
        }
        return this.context;
    }

    public void setContext(String string) {
        this.context = string;
    }

    public boolean isPrintUsage() {
        return this.printUsage;
    }

    public void setPrintUsage(boolean bl) {
        this.printUsage = bl;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    static CliOptions parse(String ... stringArray) {
        CliOptions cliOptions = new CliOptions();
        CmdLineParser cmdLineParser = new CmdLineParser((Object)cliOptions);
        try {
            cmdLineParser.parseArgument(stringArray);
            if (cliOptions.isPrintUsage()) {
                CliOptions.printUsage(cmdLineParser, System.err);
                return null;
            }
        }
        catch (CmdLineException cmdLineException) {
            System.err.println(cmdLineException.getMessage());
            CliOptions.printUsage(cmdLineParser, System.out);
            return null;
        }
        return cliOptions;
    }

    private static void printUsage(CmdLineParser cmdLineParser, PrintStream printStream) {
        printStream.println("Usage: ./cli." + (System.getProperty("os.name").matches("(?i).*windows.*") ? "cmd" : "sh") + " [options] [[--] arguments]\n");
        printStream.println("Options:\n");
        cmdLineParser.printUsage((OutputStream)printStream);
    }
}

