/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api.internal;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.rest.ResponseExtractor;
import com.xebialabs.deployit.core.api.ReferenceDataProxy;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDescriptorList;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemMethodDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemPropertyDescriptorDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemPropertyKind;
import java.util.Arrays;
import java.util.Set;

public class DescriptorHelper {
    private static volatile DescriptorHelper instance;
    private ReferenceDataProxy descriptorProxy;
    private Set<String> simpleNameMap = Sets.newHashSet();

    public DescriptorHelper(Proxies proxies) {
        this.descriptorProxy = proxies.getReferenceData();
        this.initialize();
    }

    private void initialize() {
        ConfigurationItemDescriptorList configurationItemDescriptorList = (ConfigurationItemDescriptorList)new ResponseExtractor(this.descriptorProxy.list()).getEntity();
        this.registerSimpleNames(configurationItemDescriptorList);
    }

    private void registerSimpleNames(ConfigurationItemDescriptorList configurationItemDescriptorList) {
        for (ConfigurationItemDescriptorDto configurationItemDescriptorDto : configurationItemDescriptorList.getDescriptors()) {
            this.simpleNameMap.add(configurationItemDescriptorDto.getType());
        }
    }

    public static DescriptorHelper getInstance(Proxies proxies) {
        if (instance == null) {
            instance = new DescriptorHelper(proxies);
        }
        return instance;
    }

    public String getRegisteredType(String string) {
        return this.isTypeRegistered(string) ? string : null;
    }

    public boolean isTypeRegistered(String string) {
        return this.simpleNameMap.contains(string);
    }

    public static void describe(String string) {
        instance.describeType(string);
    }

    private void describeType(String string) {
        String string2 = this.getRegisteredType(string);
        if (string2 == null) {
            System.out.println();
            System.out.printf("No ConfigurationItem named \"%s\" found.\n", string);
            System.out.println();
            return;
        }
        ConfigurationItemDescriptorDto configurationItemDescriptorDto = (ConfigurationItemDescriptorDto)new ResponseExtractor(this.descriptorProxy.find(string2)).getEntity();
        System.out.println();
        System.out.printf("ConfigurationItem %s:\n", configurationItemDescriptorDto.getType());
        System.out.printf("Description: %s\n", configurationItemDescriptorDto.getDescription());
        System.out.println("Control tasks:");
        for (ConfigurationItemMethodDescriptorDto configurationItemMethodDescriptorDto : configurationItemDescriptorDto.getControlTasks()) {
            System.out.printf("\t. %s: %s\n", configurationItemMethodDescriptorDto.getName(), configurationItemMethodDescriptorDto.getDescription());
        }
        System.out.println("Properties:");
        for (ConfigurationItemMethodDescriptorDto configurationItemMethodDescriptorDto : configurationItemDescriptorDto.getPropertyDescriptors()) {
            System.out.printf("\t%s %s(%s): %s\n", this.getPropertyModifier((ConfigurationItemPropertyDescriptorDto)configurationItemMethodDescriptorDto), configurationItemMethodDescriptorDto.getName(), this.getType((ConfigurationItemPropertyDescriptorDto)configurationItemMethodDescriptorDto), configurationItemMethodDescriptorDto.getDescription());
            if (configurationItemMethodDescriptorDto.getType() != ConfigurationItemPropertyKind.ENUM) continue;
            System.out.printf("\t\tValues: %s\n", Arrays.toString(configurationItemMethodDescriptorDto.getEnumValues()));
        }
        System.out.println();
        System.out.println("Properties marked with a '!' are required for discovery.");
        System.out.println("Properties marked with a '*' are required.");
        System.out.println();
    }

    private String getPropertyModifier(ConfigurationItemPropertyDescriptorDto configurationItemPropertyDescriptorDto) {
        if (configurationItemPropertyDescriptorDto.isDiscoveryRequired()) {
            return "!";
        }
        return configurationItemPropertyDescriptorDto.isRequired() ? "*" : "-";
    }

    private String getType(ConfigurationItemPropertyDescriptorDto configurationItemPropertyDescriptorDto) {
        ConfigurationItemPropertyKind configurationItemPropertyKind = configurationItemPropertyDescriptorDto.getType();
        switch (configurationItemPropertyKind) {
            case CI: {
                return configurationItemPropertyDescriptorDto.getPropertyClassname();
            }
            case SET_OF_CI: {
                return String.format("Set<%s>", configurationItemPropertyDescriptorDto.getCollectionMemberClassname());
            }
            case LIST_OF_CI: {
                return String.format("List<%s>", configurationItemPropertyDescriptorDto.getCollectionMemberClassname());
            }
            case SET_OF_STRING: {
                return "Set<String>";
            }
            case LIST_OF_STRING: {
                return "List<String>";
            }
        }
        return configurationItemPropertyDescriptorDto.getType().name();
    }

    public Set<String> types() {
        return this.simpleNameMap;
    }
}

