/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.google.common.base.Joiner;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.api.internal.DescriptorHelper;
import com.xebialabs.deployit.cli.api.internal.ImportHelper;
import com.xebialabs.deployit.cli.api.internal.PrintHelper;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.cli.rest.ResponseExtractor;
import com.xebialabs.deployit.core.api.dto.Comparison;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDtos;
import com.xebialabs.deployit.core.api.dto.ImportablePackages;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.dto.ServerInfo;
import com.xebialabs.deployit.core.api.dto.TaskInfo;
import com.xebialabs.deployit.core.api.dto.TaskInfos;
import java.util.Collection;
import java.util.List;

@CliObject(name="deployit")
@ClassHelp(description="The main gateway to interfacing with Deployit.")
public class DeployitClient
extends DocumentedObject {
    private final Proxies proxies;

    public DeployitClient() {
        this.proxies = null;
    }

    public DeployitClient(Proxies proxies) {
        this.proxies = proxies;
    }

    @MethodHelp(description="Import a package located on the server or local file system.", parameters={@ParameterHelp(name="importablePackage", description="This is either:\n\t- The name of the importable package on the server\n\t- The absolute path to a local importable package.")})
    public RepositoryObject importPackage(String string) {
        return new ImportHelper().doImport(this.proxies.getAuthentication().getHttpClient(), this.proxies.getHost(), string);
    }

    @MethodHelp(description="List all importable packages on the server.")
    public List<String> listImportablePackages() {
        return ((ImportablePackages)new ResponseExtractor(this.proxies.getImportablePackage().list()).getEntity()).getFiles();
    }

    @MethodHelp(description="Retrieve the task information for a (running) deployment task.", parameters={@ParameterHelp(name="taskId", description="The id of the task.")}, returns="The metadata associated with the task")
    public TaskInfo retrieveTaskInfo(String string) {
        return (TaskInfo)new ResponseExtractor(this.proxies.getTaskRegistry().getTaskInfo(string)).getEntity();
    }

    @MethodHelp(description="Gracefully stop an active deployment task", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void stopTask(String string) {
        new ResponseExtractor(this.proxies.getTaskRegistry().stop(string));
    }

    @MethodHelp(description="Start a deployment task", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void startTask(String string) {
        new ResponseExtractor(this.proxies.getTaskRegistry().start(string));
    }

    @MethodHelp(description="Start a deployment task and wait for it to finish", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void startTaskAndWait(String string) {
        this.startTask(string);
        boolean bl = false;
        TaskInfo taskInfo = null;
        while (!bl) {
            taskInfo = (TaskInfo)new ResponseExtractor(this.proxies.getTaskRegistry().getTaskInfo(string)).getEntity();
            String string2 = taskInfo.getState();
            if ("DONE".equals(string2) || "ABORTED".equals(string2) || "STOPPED".equals(string2)) {
                bl = true;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @MethodHelp(description="Abort an active deployment task", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void abortTask(String string) {
        new ResponseExtractor(this.proxies.getTaskRegistry().abort(string));
    }

    @MethodHelp(description="Cancel a stopped deployment task", parameters={@ParameterHelp(name="taskId", description="The id of the task.")})
    public void cancelTask(String string) {
        new ResponseExtractor(this.proxies.getTaskRegistry().cancel(string));
    }

    @MethodHelp(description="List unfinished tasks for the current user.")
    public List<TaskInfo> listUnfinishedTasks() {
        return ((TaskInfos)new ResponseExtractor(this.proxies.getTaskRegistry().getUnfinishedTasks()).getEntity()).getTasks();
    }

    @MethodHelp(description="List all unfinished tasks registered in the server. Requires administrative permission.")
    public List<TaskInfo> listAllUnfinishedTasks() {
        return ((TaskInfos)new ResponseExtractor(this.proxies.getTaskRegistry().getAllUnfinishedTasks()).getEntity()).getTasks();
    }

    @MethodHelp(description="(Un)skip steps of the task.\n- If a step is in the PENDING or FAILED state, it will be SKIPPED.\n- If a step is in the SKIPPED state it will be PENDING. ", parameters={@ParameterHelp(name="taskId", description="The id of the task"), @ParameterHelp(name="stepIds", description="The ids of the steps to skip or unskip")})
    public void skipSteps(String string, Integer[] integerArray) {
        String string2 = Joiner.on((String)",").join((Object[])integerArray);
        new ResponseExtractor(this.proxies.getTaskRegistry().toggleSkipSteps(string, string2));
    }

    @MethodHelp(description="Assign a pending task to another principal", parameters={@ParameterHelp(name="taskId", description="The id of the task."), @ParameterHelp(name="owner", description="The new task owner.")})
    public void assignTask(String string, String string2) {
        new ResponseExtractor(this.proxies.getTaskRegistry().assignTask(string, string2));
    }

    @MethodHelp(description="Discover middleware associated with the specified discoverable configuration item. Refer to plugin configuration item documentation to see which fields are required for discover.", parameters={@ParameterHelp(name="ci", description="The configuration item with all required discovery fields filled in")}, returns="RepositoryObjects containing all discovered middleware associated with the specified discoverable ci")
    public ConfigurationItemDtos discover(ConfigurationItemDto configurationItemDto) {
        return (ConfigurationItemDtos)new ResponseExtractor(this.proxies.getDiscovery().discover(configurationItemDto)).getEntity();
    }

    @MethodHelp(description="Execute the control task on the provided configuration item. If the control tasks executes successfully, no output is shown. In the case of an error, log output is shown.", parameters={@ParameterHelp(name="taskName", description="The control task name eg. \"start\""), @ParameterHelp(name="ci", description="The configuration item to execute the control task on")})
    public void executeControlTask(String string, ConfigurationItemDto configurationItemDto) {
        new ResponseExtractor(this.proxies.getControlTask().execute(string, configurationItemDto.getId()));
    }

    @MethodHelp(description="Describe the CI class, with all the values it takes.", parameters={@ParameterHelp(name="shortName", description="The (Short) name of the CI eg. \"Host\", \"WasDataSource\", etc")})
    public void describe(String string) {
        DescriptorHelper.describe(string);
    }

    @MethodHelp(description="Print a tree-view of a CI", parameters={@ParameterHelp(name="ci", description="The CI to print")})
    public void print(RepositoryObject repositoryObject) {
        PrintHelper.getInstance().printCi(repositoryObject, this.proxies);
    }

    public void print(Collection<RepositoryObject> collection) {
        PrintHelper.getInstance().printCis(collection, this.proxies);
    }

    public Comparison compare(String string, List<String> list) {
        return (Comparison)new ResponseExtractor(this.proxies.getQuery().compare(string, list)).getEntity();
    }

    @MethodHelp(description="Retrieve Deployit server information")
    public ServerInfo info() {
        return (ServerInfo)new ResponseExtractor(this.proxies.getServer().getInfo()).getEntity();
    }

    @MethodHelp(description="Run the Deployit server garbage collector")
    public void runGarbageCollector() {
        new ResponseExtractor(this.proxies.getServer().gc());
    }

    @MethodHelp(description="Shutdown the Deployit server")
    public void shutdown() {
        new ResponseExtractor(this.proxies.getServer().shutdown());
    }
}

