/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.ssl;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.cli.ssl.SelfSignedCertificateTrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.HttpClientError;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SelfSignedCertificateAcceptingSocketFactory
implements SecureProtocolSocketFactory {
    private static final Logger logger = LoggerFactory.getLogger(SelfSignedCertificateAcceptingSocketFactory.class);
    private AtomicReference<SSLContext> sslcontext = new AtomicReference();

    private static SSLContext createLenientSSLContext() {
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, new TrustManager[]{new SelfSignedCertificateTrustManager(null)}, null);
            return sSLContext;
        }
        catch (Exception exception) {
            logger.error("Exception setting up the SSL Context.", (Throwable)exception);
            throw new HttpClientError("Exception setting up the SSL Context: " + exception);
        }
    }

    private SSLContext getSSLContext() {
        if (this.sslcontext.get() == null) {
            this.sslcontext.set(SelfSignedCertificateAcceptingSocketFactory.createLenientSSLContext());
        }
        return this.sslcontext.get();
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        return this.getSSLContext().getSocketFactory().createSocket(string, n, inetAddress, n2);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2, HttpConnectionParams httpConnectionParams) throws IOException {
        Preconditions.checkNotNull((Object)httpConnectionParams, (Object)"Parameters should be set");
        int n3 = httpConnectionParams.getConnectionTimeout();
        SSLSocketFactory sSLSocketFactory = this.getSSLContext().getSocketFactory();
        if (n3 == 0) {
            return sSLSocketFactory.createSocket(string, n, inetAddress, n2);
        }
        Socket socket = sSLSocketFactory.createSocket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n2);
        InetSocketAddress inetSocketAddress2 = new InetSocketAddress(string, n);
        socket.bind(inetSocketAddress);
        socket.connect(inetSocketAddress2, n3);
        return socket;
    }

    public Socket createSocket(String string, int n) throws IOException {
        return this.getSSLContext().getSocketFactory().createSocket(string, n);
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        return this.getSSLContext().getSocketFactory().createSocket(socket, string, n, bl);
    }

    public boolean equals(Object object) {
        return object != null && this.getClass().equals(object.getClass());
    }

    public int hashCode() {
        return SelfSignedCertificateAcceptingSocketFactory.class.hashCode();
    }
}

