package com.xebialabs.deployit.cli.help;

import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;
import java.util.Collection;
import static java.lang.System.out;
import static java.lang.String.format;

public class PermissionPrinter {

	private PermissionPrinter() {		
	}

	public static void listPermissions(final Map<String, Set<String>> permissionTargetSet) {
		if ((permissionTargetSet == null) || permissionTargetSet.isEmpty()) {
			out.print("There are no permissions set for the requested user, or the requested user doesn't exist!\n\n");
		} else {
			for (String permissionTarget : permissionTargetSet.keySet()) {
				if (permissionTargetSet.get(permissionTarget).contains("")) {
					out.print(format("\nGranted global permission \'%s\'\n", permissionTarget));
				} else {
					printSetOfValues(format("\nGranted permission \'%s\' on:\n", permissionTarget), permissionTargetSet.get(permissionTarget));
					out.println();
				}
			}
		}
	}

	public static void listPermissionsOnTargets(final Collection<? extends String> targets, final Map<String, Set<String>> targetsWithPermissions) {
		for (String target : targets) {
			listPermissionsOnTarget(target, targetsWithPermissions);
		}
	}

	public static void listPermissionsOnTarget(final String target, final Map<String, Set<String>> targetsWithPermissions) {
		if ((targetsWithPermissions == null) || targetsWithPermissions.isEmpty()) {
			out.print(format("There are no permissions set for the requested user on \'%s\' or the requested user doesn't exist!\n\n", target));
		} else {
			out.println();
			if (targetsWithPermissions.containsKey(target)){
				printSetOfValues(format("Permissions on \'%s\':\n", target), targetsWithPermissions.get(target));
			} else if ((targetsWithPermissions.size() == 1) && targetsWithPermissions.containsKey("")) {
				printSetOfValues(format("Permissions on \'%s\':\n", target), targetsWithPermissions.get(""));
			} else {
				out.print(format("Permissions on \'%s\':\n\tNo permissions found\n", target));
			}
			out.println();
		}
	}

	public static void listPermissionsOnTargets(final Map<String, Set<String>> targetsWithPermissions){
		if ((targetsWithPermissions == null) || targetsWithPermissions.isEmpty()) {
			out.print("There are no permissions set for the requested user, or the requested user doesn't exist!\n\n");
		} else {
			if (targetsWithPermissions.containsKey("")) {
				printSetOfValues("\nGlobal permissions:\n", targetsWithPermissions.get(""));
			}
			for (Entry<String, Set<String>> target : targetsWithPermissions.entrySet()) {
				if (!target.getKey().equals("")) {
					printSetOfValues(format("\nPermissions on \'%s\':\n", target.getKey()), target.getValue());
				}
			}
			out.println();
		}
	}
	
	private static void printSetOfValues(final String text, final Set<String> values) {
		out.print(text);
		for (String value : values) {
			out.print(format("\t %s\n", value));
		}
	}
}
