/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.help;

import com.xebialabs.deployit.cli.Cli;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class ExportHelp {
    private ExportHelp() {
    }

    public static final String parseDateFormat(String dateToFormat, String parseFormat, String resultFormat) {
        try {
            SimpleDateFormat parseDateFormat = new SimpleDateFormat(parseFormat);
            parseDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            SimpleDateFormat resultDateFormat = new SimpleDateFormat(resultFormat);
            resultDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return resultDateFormat.format(parseDateFormat.parse(dateToFormat));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(String.format("Cannot parse date; should be in format %s", parseFormat));
        }
    }

    public static final String encodeURIDateFormat(String date, String charSet) {
        try {
            return URLEncoder.encode(date, charSet);
        }
        catch (UnsupportedEncodingException parseException) {
            throw new IllegalArgumentException(String.format("Cannot parse date because of unsupported encoding; should be in %s encoding", charSet));
        }
    }

    public static final long writeResourceToLocalFile(Cli.Authentication authentication, String filePath, String resourceURL) throws IOException {
        FileOutputStream outputResourceFile = null;
        try {
            HttpClient httpClient = authentication.getHttpClient();
            GetMethod getMethod = new GetMethod(resourceURL);
            int responseCode = httpClient.executeMethod((HttpMethod)getMethod);
            if (responseCode == 200) {
                long bytesWritten = 0L;
                outputResourceFile = new FileOutputStream(filePath);
                FileChannel fileChannel = outputResourceFile.getChannel();
                if (fileChannel.isOpen()) {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(50000);
                    ReadableByteChannel resourceStream = Channels.newChannel(getMethod.getResponseBodyAsStream());
                    while (resourceStream.read(byteBuffer) > 0) {
                        byteBuffer.flip();
                        fileChannel.write(byteBuffer);
                        fileChannel.force(false);
                        byteBuffer.clear();
                    }
                    bytesWritten = fileChannel.size();
                    fileChannel.close();
                    resourceStream.close();
                }
                long l = bytesWritten;
                return l;
            }
            try {
                if (responseCode == 401 || responseCode == 403) {
                    throw new IllegalStateException("You were not authenticated correctly, did you use the correct credentials?");
                }
                throw new IllegalStateException("Could contact the server at " + httpClient.getHostConfiguration().getHost() + " but received an HTTP error code, " + responseCode);
            }
            catch (IOException outputFileException) {
                throw new IOException(String.format("The file at %s could not be created.", filePath));
            }
        }
        finally {
            if (outputResourceFile != null) {
                outputResourceFile.close();
            }
        }
    }
}

