package com.xebialabs.deployit.cli.rest;

import javax.ws.rs.core.Response;
import com.xebialabs.deployit.core.api.resteasy.InternalServerErrorClientResponseInterceptor;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.BaseClientResponse;

/**
 */
public class ResponseExtractor {

	private final ClientResponse<?> response;

	public static <T> T getEntity(final Response response) {
		return new ResponseExtractor(response).<T>getEntity();
	}

	public ResponseExtractor(final Response response) {
		if (!(response instanceof ClientResponse)) {
			throw new IllegalArgumentException("Not a client response: " + response);
		}
		this.response = (ClientResponse<?>) response;
		checkResponse();
	}

	private void checkResponse() {
		final int status = response.getStatus();
		if (isNotOkStatus(status)) {
			new InternalServerErrorClientResponseInterceptor().handle(response);
		}
	}

    private boolean isNotOkStatus(final int status) {
        return 399 < status && status < 699;
    }

    @SuppressWarnings({ "unchecked" })
    public <T> T getEntity() {
		return (T) ((BaseClientResponse<?>) response).getEntity();
	}

    public boolean isValidResponse() {
        return !isNotOkStatus(response.getStatus());
    }
}
