/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.help;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;

public class HelpScanner {
    private static final AtomicReference<Set<Class<?>>> discoveredCliObjects = new AtomicReference();

    public static void printHelp(Set<Class<?>> clazzes) {
        discoveredCliObjects.set(clazzes);
        HelpScanner.printHelp();
    }

    public static void printHelp() {
        TreeSet availableCliObjects = Sets.newTreeSet((Comparator)new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> clazz, Class<?> clazzComparedTo) {
                return clazz.getSimpleName().compareTo(clazzComparedTo.getSimpleName());
            }
        });
        availableCliObjects.addAll((Collection)discoveredCliObjects.get());
        System.out.println("Deployit Objects available on the CLI:\n");
        for (Class clazz : availableCliObjects) {
            ClassHelp classHelp = clazz.getAnnotation(ClassHelp.class);
            CliObject cliObject = clazz.getAnnotation(CliObject.class);
            if (classHelp == null) continue;
            System.out.printf("* %s: %s\n", cliObject.name(), classHelp.description());
        }
        System.out.println("\nTo know more about a specific object, type <objectname>.help()");
        System.out.println("To get to know more about a specific method of an object, type <objectname>.help(\"<methodname>\")\n");
    }

    public static void printHelp(Class<?> clazz) {
        ClassHelp classHelp = clazz.getAnnotation(ClassHelp.class);
        CliObject cliObject = clazz.getAnnotation(CliObject.class);
        if (classHelp != null) {
            String objectName = cliObject.name();
            System.out.printf("%s: %s\n\n", objectName, classHelp.description());
            HelpScanner.printMethods(objectName, clazz);
            System.out.println();
        } else {
            System.out.println("Not found help for " + clazz);
        }
    }

    public static void printHelp(Class<?> clazz, String methodName) throws NoSuchMethodException {
        ClassHelp classHelp = clazz.getAnnotation(ClassHelp.class);
        CliObject cliObject = clazz.getAnnotation(CliObject.class);
        if (classHelp != null) {
            String objectName = cliObject.name();
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(methodName)) continue;
                HelpScanner.printMethod(objectName, method);
                HelpScanner.printMethodDetails(method);
                System.out.println();
            }
        }
    }

    private static void printMethodDetails(Method method) {
        MethodHelp methodHelp = method.getAnnotation(MethodHelp.class);
        if (methodHelp != null) {
            System.out.println();
            System.out.printf("Description:\n%s\n\n", methodHelp.description());
            System.out.print("Parameters:\n");
            if (methodHelp.parameters().length != 0) {
                for (ParameterHelp parameterHelp : methodHelp.parameters()) {
                    System.out.printf("  %s: %s\n", parameterHelp.name(), parameterHelp.description());
                }
            } else {
                System.out.print("None\n");
            }
            System.out.println();
            System.out.printf("Returns:\n%s - %s\n", method.getReturnType().getSimpleName(), methodHelp.returns());
        }
    }

    private static void printMethods(String objectName, Class<?> clazz) {
        ArrayList availableMethods = Lists.newArrayList((Object[])clazz.getDeclaredMethods());
        Collections.sort(availableMethods, new Comparator<Method>(){

            @Override
            public int compare(Method method, Method methodComparedTo) {
                if (method.getName().equals(methodComparedTo.getName())) {
                    return 0;
                }
                return method.getName().compareTo(methodComparedTo.getName());
            }
        });
        System.out.println("The methods available are:");
        for (Method method : availableMethods) {
            HelpScanner.printMethod(objectName, method);
        }
    }

    private static void printMethod(String objectName, Method method) {
        MethodHelp methodHelp = method.getAnnotation(MethodHelp.class);
        if (methodHelp != null) {
            ParameterHelp[] parameterHelps;
            String methodName = method.getName();
            StringBuilder params = new StringBuilder();
            Class<?>[] classes = method.getParameterTypes();
            if (classes.length != (parameterHelps = methodHelp.parameters()).length) {
                throw new IllegalArgumentException("Not all parameters are documented!");
            }
            for (int i = 0; i < classes.length; ++i) {
                params.append(classes[i].getSimpleName());
                params.append(" ").append(parameterHelps[i].name());
                if (i >= classes.length - 1) continue;
                params.append(", ");
            }
            System.out.printf("* %s.%s(%s) : %s\n", objectName, methodName, params, method.getReturnType().getSimpleName());
        }
    }
}

