/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api.internal;

import com.google.common.io.Files;
import com.xebialabs.deployit.cli.rest.ResponseExtractor;
import com.xebialabs.deployit.core.api.ImportablePackageProxy;
import com.xebialabs.deployit.core.api.dto.FileUpload;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportHelper {
    private static final Logger logger = LoggerFactory.getLogger(ImportHelper.class);

    public static RepositoryObject doImport(ImportablePackageProxy proxy, String packageToImport) {
        Response response;
        try {
            URL url = new URL(packageToImport);
            response = url.getProtocol().equals("file") ? ImportHelper.processFilePath(proxy, url.getFile()) : proxy.importPackageFromUrl(url.toString());
        }
        catch (MalformedURLException e) {
            response = ImportHelper.processFilePath(proxy, packageToImport);
        }
        return (RepositoryObject)new ResponseExtractor(response).getEntity();
    }

    private static Response processFilePath(ImportablePackageProxy proxy, String path) {
        Response response;
        File file = new File(path);
        if (file.exists()) {
            FileUpload fileUpload = new FileUpload();
            try {
                fileUpload.setFileData(Files.toByteArray((File)file));
                response = proxy.importUploadedPackage(file.getName(), fileUpload);
            }
            catch (IOException e) {
                logger.error("The file '{}' exists, but could not be read for upload; perhaps it's not an archive.", (Object)file.toString());
                return null;
            }
        } else if (!file.isAbsolute()) {
            response = proxy.importPackage(path);
        } else {
            logger.error("The file '{}' does not exist at the given absolute path", (Object)file.toString());
            return null;
        }
        return response;
    }
}

