package com.xebialabs.deployit.cli.api;

import java.util.Map;
import java.util.HashMap;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.executors.ApacheHttpClientExecutor;
import com.xebialabs.deployit.cli.Cli;
import com.xebialabs.deployit.cli.CliOptions;
import com.xebialabs.deployit.core.api.*;
import com.xebialabs.deployit.core.api.resteasy.ResteasyHelper;

/**
 */
public class Proxies {
	private final Map<Class<?>, Object> registeredProxies = new HashMap<Class<?>, Object>();
	private final Cli.Authentication authentication;
	private final String host;

	public Proxies(final CliOptions options, final Cli.Authentication authentication) {
		this.authentication = authentication;
		host = options.getUrl();
		ResteasyHelper.buildDefaultResteasyProviderFactory().build();
		registerProxies();
	}

	private void registerProxies() {
		registerProxy(DeploymentProxy.class);
		registerProxy(ImportablePackageProxy.class);
		registerProxy(RepositoryProxy.class);
		registerProxy(QueryProxy.class);
		registerProxy(UserProxy.class);
		registerProxy(DiscoveryProxy.class);
		registerProxy(HistoryProxy.class);
        registerProxy(DescriptorProxy.class);
        registerProxy(TaskProxy.class);
        registerProxy(ExportProxy.class);
        registerProxy(ReportProxy.class);
		registerProxy(SecurityProxy.class);
		registerProxy(ServerProxy.class);
	}

	private void registerProxy(final Class<?> proxyClass) {
		final ApacheHttpClientExecutor clientExecutor = new ApacheHttpClientExecutor(authentication.getHttpClient());

		registeredProxies.put(proxyClass, ProxyFactory.create(proxyClass, host, clientExecutor));
	}

	@SuppressWarnings("unchecked")
	private <T> T getRestEasyProxyInstance(Class<T> proxyClass) {
		return (T) registeredProxies.get(proxyClass);
	}

	public final Cli.Authentication getAuthentication(){
		return this.authentication;
	}
	
	public DeploymentProxy getDeployment() {
		return getRestEasyProxyInstance(DeploymentProxy.class);
	}

	public ImportablePackageProxy getImportablePackage() {
		return getRestEasyProxyInstance(ImportablePackageProxy.class);
	}

	public RepositoryProxy getRepository() {
		return getRestEasyProxyInstance(RepositoryProxy.class);
	}

	public QueryProxy getQuery() {
		return getRestEasyProxyInstance(QueryProxy.class);
	}
	
	public HistoryProxy getHistory() {
		return getRestEasyProxyInstance(HistoryProxy.class);
	}

	public DiscoveryProxy getDiscovery() {
		return getRestEasyProxyInstance(DiscoveryProxy.class);
	}

	public TaskProxy getTaskRegistry() {
		return getRestEasyProxyInstance(TaskProxy.class);
	}
	
	public ExportProxy getTaskExport() {
		return getRestEasyProxyInstance(ExportProxy.class);
	}

	public UserProxy getUser() {
		return getRestEasyProxyInstance(UserProxy.class);
	}

    public DescriptorProxy getDescriptors() {
        return getRestEasyProxyInstance(DescriptorProxy.class);
    }
    
    public ReportProxy getReport() {
    	return getRestEasyProxyInstance(ReportProxy.class);
    }

	public SecurityProxy getSecurity() {
		return getRestEasyProxyInstance(SecurityProxy.class);
	}

	public ServerProxy getServer() {
		return getRestEasyProxyInstance(ServerProxy.class);
	}
}
