/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.util;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.cli.util.Base64Coder;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class PasswordEncrypter {
    private static final Base64Coder BASE_64_CODER = new Base64Coder();
    private static final AtomicReference<PasswordEncrypter> instance = new AtomicReference();
    public static final SecretKey PASSWORD_ENCRYPTION_KEY = new SecretKeySpec(new byte[]{-29, -22, 22, -81, -108, 95, 91, 23, 46, -26, 49, -45, -64, 112, 39, -42}, "AES");

    private PasswordEncrypter() {
    }

    public static void init() {
        instance.set(new PasswordEncrypter());
    }

    public static PasswordEncrypter getInstance() {
        Preconditions.checkState((instance.get() != null ? 1 : 0) != 0, (Object)"PasswordEncrypter not yet set, please construct one.");
        return instance.get();
    }

    public boolean isEncoded(String text) {
        try {
            BASE_64_CODER.decode(text.getBytes());
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public boolean isEncrypted(String text) {
        if (this.isEncoded(text)) {
            byte[] decode = BASE_64_CODER.decode(text.getBytes());
            try {
                Cipher cipher = this.getCipher(2);
                cipher.doFinal(decode);
                return true;
            }
            catch (GeneralSecurityException e) {
                throw new IllegalStateException("Could not decrypt Base64 encoded password");
            }
        }
        return false;
    }

    private String encrypt(String plaintext) {
        Preconditions.checkNotNull((Object)plaintext, (Object)"The password is null");
        Preconditions.checkArgument((!plaintext.startsWith(BASE_64_CODER.identifier()) ? 1 : 0) != 0, (Object)("The password contains the illegal sequence " + BASE_64_CODER.identifier()));
        try {
            Cipher aes = this.getCipher(1);
            return new String(BASE_64_CODER.encode(aes.doFinal(plaintext.getBytes())));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not encrypt the password.");
        }
    }

    public String ensureEncrypted(String text) {
        if (this.isEncrypted(text)) {
            return text;
        }
        return this.encrypt(text);
    }

    private String decrypt(String encryptedText) {
        Preconditions.checkArgument((encryptedText != null ? 1 : 0) != 0, (Object)"The password is null");
        Preconditions.checkArgument((boolean)encryptedText.startsWith(BASE_64_CODER.identifier()), (Object)"The password should be Base64 encoded");
        try {
            Cipher aes = this.getCipher(2);
            return new String(aes.doFinal(BASE_64_CODER.decode(encryptedText.getBytes())));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not decrypt the password.");
        }
    }

    public String ensureDecrypted(String text) {
        if (this.isEncrypted(text)) {
            return this.decrypt(text);
        }
        return text;
    }

    private Cipher getCipher(int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher aes = Cipher.getInstance(PASSWORD_ENCRYPTION_KEY.getAlgorithm());
        aes.init(mode, PASSWORD_ENCRYPTION_KEY);
        return aes;
    }
}

