/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.help;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class DateHelp {
    public static final String DATE_FORMAT_FOR_SERVER = "yyyy-MM-dd";
    public static final String DATE_FORMAT_IN_CLI = "MM/dd/yyyy";
    public static final DateTimeFormatter FORMATTER_CLI = DateTimeFormat.forPattern((String)"MM/dd/yyyy");

    private DateHelp() {
    }

    public static final String transform(String dateAsString, String fromFormat, String toFormat) {
        try {
            SimpleDateFormat parseDateFormat = new SimpleDateFormat(fromFormat, Locale.ENGLISH);
            parseDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            SimpleDateFormat resultDateFormat = new SimpleDateFormat(toFormat, Locale.ENGLISH);
            resultDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return resultDateFormat.format(parseDateFormat.parse(dateAsString));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(String.format("Cannot parse date; should be in format %s", fromFormat));
        }
    }

    public static final String urlEncode(String date) {
        String charSet = "UTF-8";
        try {
            return URLEncoder.encode(date, charSet);
        }
        catch (UnsupportedEncodingException parseException) {
            throw new IllegalArgumentException(String.format("Cannot parse date because of unsupported encoding; should be in %s encoding", charSet));
        }
    }

    public static LocalDate toLocalDate(String cliDateString) {
        return LocalDate.parse((String)cliDateString, (DateTimeFormatter)FORMATTER_CLI);
    }
}

