/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.ProxiesInstance;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.core.api.dto.ActiveUserSession;
import com.xebialabs.deployit.core.api.dto.UserSessionsOverview;
import java.util.List;

@CliObject(name="session")
@ClassHelp(description="Access to the active sessions and it's overview.")
public class SessionClient
extends DocumentedObject {
    private ProxiesInstance proxies;

    public SessionClient() {
    }

    public SessionClient(ProxiesInstance proxies) {
        this.proxies = proxies;
    }

    @MethodHelp(description="Lists all active sessions.", parameters={@ParameterHelp(name="principalPattern", description="The principal pattern name.")}, returns="List of active sessions.")
    public List<ActiveUserSession> getActiveSessions(String principalPattern) {
        return this.proxies.getSessionService().getActiveSessions(principalPattern, null, null);
    }

    @MethodHelp(description="Lists active sessions summary.", returns="Active sessions overview.")
    public UserSessionsOverview getSessionsOverview() {
        return this.proxies.getSessionService().getSessionsOverview();
    }
}

