/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Strings2 {
    private static final char QUERY_STRING_ATTRIBUTES_SEPARATOR = '&';
    private static final String QUERY_STRING_ATTRIBUTE_KEY_VALUE_SEPARATOR = Pattern.quote("=");
    private static final char COMMA_SEPARATOR = ',';
    private static final String QUOTE_CHARACTER = "\"";

    @Nonnull
    public static Map<String, String> uriQueryStringToMap(@Nonnull String queryString) {
        ImmutableMap.Builder inProgress = ImmutableMap.builder();
        for (String keyValue : Splitter.on((char)'&').split((CharSequence)queryString)) {
            String[] keyAndValue = keyValue.split(QUERY_STRING_ATTRIBUTE_KEY_VALUE_SEPARATOR);
            Preconditions.checkArgument((keyAndValue.length == 2 ? 1 : 0) != 0, (String)"Invalid query string format. Expected 'key=value&key2=value&...' but found section '%s'", (Object[])new Object[]{keyValue});
            inProgress.put((Object)keyAndValue[0], (Object)keyAndValue[1]);
        }
        return inProgress.build();
    }

    @Nonnull
    public static List<String> commaSeparatedListToList(@Nonnull String commaSeparatedList) {
        return ImmutableList.copyOf((Iterable)Splitter.on((char)',').trimResults().split((CharSequence)commaSeparatedList));
    }

    @Nonnull
    public static String stripEnclosingQuotes(@Nonnull String value) {
        return value.length() > 1 && value.startsWith(QUOTE_CHARACTER) && value.endsWith(QUOTE_CHARACTER) ? value.substring(1, value.length() - 1) : value;
    }
}

