/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.util;

import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFinder
implements FilePath.FileCallable<List<String>> {
    private final String pattern;

    public FileFinder(String pattern) {
        this.pattern = pattern;
    }

    public List<String> invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
        return this.find(workspace);
    }

    private List<String> find(File workspace) {
        try {
            File file = new File(workspace, this.pattern);
            if (file.isDirectory()) {
                return Collections.singletonList(file.getPath());
            }
            FileSet fileSet = new FileSet();
            Project antProject = new Project();
            fileSet.setProject(antProject);
            fileSet.setDir(workspace);
            fileSet.setIncludes(this.pattern);
            String[] files = fileSet.getDirectoryScanner(antProject).getIncludedFiles();
            return files == null ? Collections.emptyList() : Arrays.asList(files);
        }
        catch (BuildException exception) {
            return Collections.emptyList();
        }
    }
}

