/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.ci.Credential;
import com.xebialabs.deployit.ci.DeployitCliCallback;
import com.xebialabs.deployit.ci.DeployitCliTemplate;
import com.xebialabs.deployit.client.DeployitCli;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployitCliCache {
    private String deployitServerUrl;
    final Cache<Credential, DeployitCliTemplate> cliTemplateCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Credential, DeployitCliTemplate>(){

        public DeployitCliTemplate load(Credential credential) throws Exception {
            if (Strings.emptyToNull((String)DeployitCliCache.this.deployitServerUrl) == null) {
                throw new RuntimeException("deployit-plugin: no deployit server url, return");
            }
            return new DeployitCliTemplate(DeployitCliCache.this.deployitServerUrl, credential);
        }
    });
    final Cache<Credential, List<String>> resourcesCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Credential, List<String>>(){

        public List<String> load(Credential key) throws Exception {
            return Lists.transform(DeployitCliCache.this.getCliTemplate(key).perform(new DeployitCliCallback<List<Descriptor>>(){

                @Override
                public List<Descriptor> call(DeployitCli cli) {
                    return cli.getDescriptors().getDeployableResources();
                }
            }), (Function)TO_TYPE);
        }
    });
    final Cache<Credential, List<String>> artifactsCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Credential, List<String>>(){

        public List<String> load(Credential key) throws Exception {
            return Lists.transform(DeployitCliCache.this.getCliTemplate(key).perform(new DeployitCliCallback<List<Descriptor>>(){

                @Override
                public List<Descriptor> call(DeployitCli cli) {
                    return cli.getDescriptors().getDeployableArtifacts();
                }
            }), (Function)TO_TYPE);
        }
    });
    private final Cache<Credential, Map<String, List<String>>> indexedPropertiesCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Credential, Map<String, List<String>>>(){

        public Map<String, List<String>> load(Credential key) throws Exception {
            return ImmutableMap.copyOf(DeployitCliCache.this.getCliTemplate(key).perform(new DeployitCliCallback<Map<String, List<String>>>(){

                @Override
                public Map<String, List<String>> call(DeployitCli cli) {
                    return cli.getDescriptors().getPropertiesIndexedByMap();
                }
            }));
        }
    });
    private static final Function<Descriptor, String> TO_TYPE = new Function<Descriptor, String>(){

        public String apply(Descriptor input) {
            return input.getType().toString();
        }
    };

    public DeployitCliCache(String deployitServerUrl) {
        this.setDeployitServerUrl(deployitServerUrl);
    }

    public DeployitCliTemplate getCliTemplate(Credential key) throws ExecutionException {
        return (DeployitCliTemplate)this.cliTemplateCache.get((Object)key);
    }

    public List<String> resources(Credential credential) {
        try {
            return (List)this.resourcesCache.get((Object)credential);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("failing when fetching resources for " + (Object)((Object)credential), e);
        }
    }

    public List<String> artifacts(Credential credential) {
        try {
            return (List)this.artifactsCache.get((Object)credential);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("failing when fetching artifacts for " + (Object)((Object)credential), e);
        }
    }

    public Map<String, List<String>> getPropertiesIndexedByType(Credential credential) {
        try {
            return (Map)this.indexedPropertiesCache.get((Object)credential);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("failing when fetching indexedPropertiesCache for " + (Object)((Object)credential), e);
        }
    }

    public void setDeployitServerUrl(String deployitServerUrl) {
        this.deployitServerUrl = deployitServerUrl;
        this.resourcesCache.invalidateAll();
        this.artifactsCache.invalidateAll();
        this.indexedPropertiesCache.invalidateAll();
    }
}

